<?php
require __DIR__ . '/../config/database.php';
session_start();

/* =============================
   HANYA ADMIN UTAMA
============================= */
if (
    empty($_SESSION['login']) ||
    ($_SESSION['user']['role'] ?? '') !== 'admin' ||
    ($_SESSION['user']['is_super'] ?? 1) != 1
) {
    exit('Akses ditolak');
}

/* =============================
   DATA ADMIN2
============================= */
$nama     = 'Admin Kedua';
$username = 'admin2';
$password = 'admin123'; // GANTI!
$role     = 'admin';
$is_super = 0;

/* =============================
   CEK USERNAME
============================= */
$cek = mysqli_prepare($conn, "SELECT id FROM users WHERE username=?");
mysqli_stmt_bind_param($cek, "s", $username);
mysqli_stmt_execute($cek);
mysqli_stmt_store_result($cek);

if (mysqli_stmt_num_rows($cek) > 0) {
    exit('Admin2 sudah ada');
}

/* =============================
   INSERT ADMIN2
============================= */
$hash = password_hash($password, PASSWORD_DEFAULT);

$stmt = mysqli_prepare($conn,
    "INSERT INTO users (nama, username, password, role, is_super)
     VALUES (?,?,?,?,?)"
);
mysqli_stmt_bind_param(
    $stmt,
    "ssssi",
    $nama,
    $username,
    $hash,
    $role,
    $is_super
);

if (mysqli_stmt_execute($stmt)) {
    echo "✅ Admin2 berhasil dibuat<br>";
    echo "Username: <b>$username</b><br>";
    echo "Password: <b>$password</b><br>";
    echo "<hr><b>SEGERA HAPUS FILE INI!</b>";
} else {
    echo "❌ Gagal menambah admin2";
}
