<?php
session_start();
require __DIR__ . '/../config/app.php';

if (!file_exists(APP_ROOT . '/install/install.lock')) {
    header("Location: ../install/index.php");
    exit;
}

require APP_ROOT . '/config/database.php';

$username = trim($_POST['username'] ?? '');
$password = $_POST['password'] ?? '';

$stmt = mysqli_prepare(
    $conn,
    "SELECT id, nama, username, password, role 
     FROM users 
     WHERE username=? 
     LIMIT 1"
);
mysqli_stmt_bind_param($stmt, "s", $username);
mysqli_stmt_execute($stmt);
$res = mysqli_stmt_get_result($stmt);

if ($u = mysqli_fetch_assoc($res)) {
    if (password_verify($password, $u['password'])) {

        session_regenerate_id(true);

        $_SESSION['login'] = true;
        $_SESSION['user']  = $u;

        // 🔔 FLAG POPUP SUKSES
        $_SESSION['login_sukses'] = true;

        // KEMBALI KE HALAMAN LOGIN
        header("Location: login.php");
        exit;
    }
}

header("Location: login.php?error=gagal");
exit;
