<?php
require __DIR__ . '/../config/database.php';

/* ================= KONEKSI DB PKBM ================= */

$conn2 = mysqli_connect("localhost","root","","pkbm_taruna_qurani");

if(!$conn2){
    die("Koneksi database pkbm_taruna_qurani gagal: ".mysqli_connect_error());
}


/* ================= SESSION ================= */
if (session_status() === PHP_SESSION_NONE) session_start();
if (empty($_SESSION['login'])) {
    header("Location: ../auth/login.php");
    exit;
}

/* ================= PROFIL ================= */
$nama_aplikasi='SMART CBT';
$nama_sekolah='SEKOLAH';
$logo='default.png';

$tables=['profil_sekolah','profil_aplikasi','setting','sekolah'];
foreach($tables as $t){
    $c=mysqli_query($conn,"SHOW TABLES LIKE '$t'");
    if($c && mysqli_num_rows($c)){
        $q=mysqli_query($conn,"SELECT * FROM $t LIMIT 1");
        if($q && mysqli_num_rows($q)){
            $s=mysqli_fetch_assoc($q);
            $nama_aplikasi=$s['nama_aplikasi']??$nama_aplikasi;
            $nama_sekolah=$s['nama_sekolah']??$nama_sekolah;
            $logo=$s['logo']??$logo;
        }
        break;
    }
}
if(!file_exists(__DIR__."/../assets/logo/$logo")) $logo='default.png';

/* ================= PAKET ================= */
$paket=mysqli_fetch_assoc(
    mysqli_query($conn,"SELECT * FROM paket_ujian WHERE status='Aktif' LIMIT 1")
);
if(!$paket) die("<div style='padding:20px'>❌ Paket ujian belum aktif</div>");

/* ================= AKSI ================= */
if(isset($_GET['aksi'],$_GET['id']) && ctype_digit($_GET['id'])){
    $id=(int)$_GET['id'];
    if($_GET['aksi']=='aktifkan'){
        mysqli_query($conn,"UPDATE ujian SET status='Aktif' WHERE id=$id");
    }elseif($_GET['aksi']=='nonaktifkan'){
    mysqli_query($conn,"UPDATE ujian SET status='Nonaktif' WHERE id=$id");
}
elseif($_GET['aksi']=='hapus'){
        mysqli_query($conn,"DELETE FROM ujian WHERE id=$id");
        mysqli_query($conn,"DELETE FROM soal WHERE id_ujian=$id");
    }
    header("Location: ujian.php"); exit;
}

/* ================= SIMPAN (FIX FINAL) ================= */
if (
    isset($_POST['simpan']) &&
    isset($_POST['nama'], $_POST['kelas'], $_POST['id_mapel'], $_POST['durasi'])
) {

    $nama     = trim($_POST['nama']);
    $id_kelas = (int) $_POST['kelas'];
    $mapel    = (int) $_POST['id_mapel'];
    $durasi   = (int) $_POST['durasi'];

    // AMAN walau auto submit
    $acakS = ($_POST['acak_soal'] ?? 'Y') === 'Y' ? 'Y' : 'N';
    $acakJ = ($_POST['acak_jawaban'] ?? 'Y') === 'Y' ? 'Y' : 'N';

    $status = 'Nonaktif';


    if ($nama !== '' && $id_kelas > 0 && $mapel > 0 && $durasi > 0) {

        $stmt = mysqli_prepare($conn,"
            INSERT INTO ujian
            (id_paket, id_kelas, id_mapel, nama_ujian, durasi, acak_soal, acak_jawaban, status)
            VALUES (?,?,?,?,?,?,?,?)
        ");

        mysqli_stmt_bind_param(
            $stmt,
            "iiisisss",
            $paket['id'],
            $id_kelas,
            $mapel,
            $nama,
            $durasi,
            $acakS,
            $acakJ,
            $status
        );

        mysqli_stmt_execute($stmt);
        mysqli_stmt_close($stmt);

        header("Location: ujian.php");
        exit;
    }
}

/* ================= DATA ================= */
$kelas_aktif = $_POST['kelas'] ?? '';

$kelas = mysqli_query($conn2,"
    SELECT 
        id,
        CONCAT(nama_kelas,'-',CHAR(64+paket_id)) AS kelas_full
    FROM kelas
    ORDER BY nama_kelas, paket_id ASC
");


$mapel = mysqli_query(
    $conn2,
    "SELECT * FROM mapel ORDER BY nama_mapel ASC"
);

$ujian = mysqli_query($conn,"
    SELECT 
        u.*, 
        m.nama_mapel, 
        CONCAT(k.nama_kelas,'-',CHAR(64+k.paket_id)) AS nama_kelas,
        (SELECT COUNT(*) FROM soal WHERE id_ujian=u.id) total_soal
    FROM ujian u
    JOIN pkbm_taruna_qurani.mapel m ON u.id_mapel = m.id
    JOIN pkbm_taruna_qurani.kelas k ON u.id_kelas = k.id
    WHERE u.id_paket = {$paket['id']}
    ORDER BY u.id DESC
");



?>
<!doctype html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title><?= $nama_aplikasi ?> | Ujian</title>
<meta name="viewport" content="width=device-width,initial-scale=1">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">
<style>
body{background:#f4f6f9}
.sidebar{width:260px;min-height:100vh;background:#1f2937;color:#fff;position:fixed}
.brand{padding:16px;background:#111827;display:flex;gap:12px;align-items:center}
.brand img{width:36px}
.sidebar a{color:#cbd5e1;padding:10px 16px;display:block;text-decoration:none}
.sidebar a:hover,.sidebar a.active{background:#2563eb;color:#fff}
.content{margin-left:260px;padding:24px}
/* FOOTER */
.footer-fixed{
  position:fixed;
  bottom:10px;
  right:16px;
  font-size:13px;
  color:#000;
}
</style>
</head>
<body>

<div class="sidebar">
<div class="brand">
<img src="../assets/logo/<?= $logo ?>">
<div><b><?= $nama_aplikasi ?></b><br><small><?= $nama_sekolah ?></small></div>
</div>
<a href="dashboard.php">Dashboard</a>
<a data-bs-toggle="collapse" href="#master">
    <i class="bi bi-database me-2"></i> Master Data
    <i class="bi bi-chevron-down float-end"></i>
  </a>
  <div class="collapse show submenu" id="master">

  </div>

  <a data-bs-toggle="collapse" href="#ujian">
  <i class="bi bi-pencil-square me-2"></i> Ujian
  <i class="bi bi-chevron-down float-end"></i>
</a>
<div class="collapse submenu" id="ujian">
  <a href="cetak_kartu_kelas.php">🖨 Cetak Kartu</a>
  <a href="paket.php">📦 Paket Ujian</a>
  <a href="ujian.php">📝 Daftar Ujian</a>
  <a href="token.php">🔑 Token</a>
</div>


  <a data-bs-toggle="collapse" href="#hasil">
  <i class="bi bi-bar-chart-line me-2"></i> Hasil
  <i class="bi bi-chevron-down float-end"></i>
</a>

<div class="collapse submenu" id="hasil">
  <a href="hasil.php">📊 Nilai</a>
  <a href="ranking.php">🏆 Ranking</a>
  <a href="laporan_jawaban.php">📝 Jawaban Siswa</a>
</div>


  <a href="../auth/logout.php">
    <i class="bi bi-box-arrow-right me-2"></i> Logout
  </a>
</div>

<div class="content">
<h4 class="fw-bold mb-3">📝 Daftar Ujian</h4>

<div class="card mb-4">
<div class="card-body">
<form method="post" class="row g-3">

<div class="col-md-2">
<select name="kelas" class="form-select" onchange="this.form.submit()" required>
<option value="">Kelas</option>
<?php while($k=mysqli_fetch_assoc($kelas)): ?>
<option value="<?= $k['id'] ?>" <?= $kelas_aktif==$k['id']?'selected':'' ?>>
<?= $k['kelas_full'] ?>
</option>
<?php endwhile ?>
</select>

</div>

<div class="col-md-3">
<input name="nama" class="form-control" placeholder="Nama Ujian" required>
</div>

<div class="col-md-3">
<select name="id_mapel" class="form-select" required>
<?php while($m=mysqli_fetch_assoc($mapel)): ?>
<option value="<?= $m['id'] ?>"><?= $m['nama_mapel'] ?></option>
<?php endwhile ?>
</select>
</div>

<div class="col-md-2">
<input type="number" min="1" name="durasi" class="form-control" placeholder="Menit" required>
</div>

<div class="col-md-2">
<select name="acak_soal" class="form-select">
<option value="Y">Acak Soal</option>
<option value="N">Tetap</option>
</select>
</div>

<div class="col-md-2">
<select name="acak_jawaban" class="form-select">
<option value="Y">Acak Jawaban</option>
<option value="N">Tetap</option>
</select>
</div>

<div class="col-md-2">
<button name="simpan" class="btn btn-primary w-100">
<i class="bi bi-plus"></i> Tambah
</button>
</div>

</form>
</div>
</div>

<div class="card">
<div class="card-body p-0">
<table class="table table-bordered mb-0">
<thead class="table-dark">
<tr>
<th>Kelas</th>
<th>Mapel</th>
<th>Ujian</th>
<th>Soal</th>
<th>Durasi</th>
<th>Status</th>
<th width="300">Aksi</th>
</tr>
</thead>
<tbody>
<?php while($u=mysqli_fetch_assoc($ujian)): ?>
<tr>
<td><?= $u['nama_kelas'] ?></td>
<td><?= $u['nama_mapel'] ?></td>
<td><?= $u['nama_ujian'] ?></td>
<td><?= $u['total_soal'] ?></td>
<td><?= $u['durasi'] ?> m</td>
<td><span class="badge bg-<?= $u['status']=='Aktif'?'success':'secondary' ?>">
<?= $u['status'] ?></span></td>
<td class="text-nowrap">
<a href="soal.php?ujian_id=<?= $u['id'] ?>"
   class="btn btn-primary btn-sm">Soal</a>

<a href="hasil.php?ujian_id=<?= $u['id'] ?>"
   class="btn btn-info btn-sm">Hasil</a>

<a href="status_ujian.php?ujian_id=<?= $u['id'] ?>"
   class="btn btn-dark btn-sm">
📊 Status
</a>

<a href="?aksi=<?= $u['status']=='Aktif'?'nonaktifkan':'aktifkan' ?>&id=<?= $u['id'] ?>"
   class="btn btn-warning btn-sm">Aktif</a>

<a href="?aksi=hapus&id=<?= $u['id'] ?>"
   onclick="return confirm('Hapus ujian & soal?')"
   class="btn btn-danger btn-sm">Hapus</a>
</td>

</tr>
<?php endwhile ?>
</tbody>
</table>
</div>
</div>

</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
<!-- ===== FOOTER ===== -->
<div class="footer-fixed">
  Dibuat Oleh : <b>Bang Zae</b>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
