<?php
require __DIR__ . '/../config/database.php';
session_start();

/* ================= PROTEKSI ADMIN ================= */
if(empty($_SESSION['login']) || ($_SESSION['user']['role'] ?? '')!=='admin'){
    header("Location: ../auth/login.php");
    exit;
}

/* ================= PROFIL SEKOLAH ================= */
$logo='default.png';
$qSekolah=mysqli_query($conn,"SELECT logo FROM sekolah LIMIT 1");
if($qSekolah && mysqli_num_rows($qSekolah)){
    $s=mysqli_fetch_assoc($qSekolah);
    if(!empty($s['logo'])) $logo=$s['logo'];
}
if(!file_exists(__DIR__."/../assets/logo/$logo")) $logo='default.png';

/* ================= LIST UJIAN AKTIF ================= */
$qUjianAktif=mysqli_query($conn,"
    SELECT u.id,u.nama_ujian,k.nama_kelas,k.paket_id
    FROM ujian u
    JOIN pkbm_taruna_qurani.kelas k ON k.id=u.id_kelas
    WHERE u.status='aktif'
    ORDER BY u.nama_ujian ASC
");
$ujianAktif=[];
while($u=mysqli_fetch_assoc($qUjianAktif)) $ujianAktif[]=$u;

/* ================= PARAM ================= */
$id_ujian=(int)($_GET['ujian_id']??0);
if($id_ujian<=0) die("Ujian tidak valid");

/* ================= SEMUA FOTO ================= */
$fotoLog=[];
$qFoto=mysqli_query($conn,"
  SELECT 
    w.id_siswa,
    w.foto,
    p.jenis_pelanggaran AS jenis
  FROM smart_cbt.webcam_log w
  LEFT JOIN smart_cbt.pelanggaran_ujian p 
    ON p.id_siswa = w.id_siswa 
   AND p.id_ujian = w.id_ujian
   AND ABS(TIMESTAMPDIFF(SECOND,p.waktu,w.waktu)) <= 3
  WHERE w.id_ujian = $id_ujian
  ORDER BY w.waktu ASC
");


while($f=mysqli_fetch_assoc($qFoto)){
    $fotoLog[$f['id_siswa']][]=[
  'foto'  => "../uploads/webcam/ujian_$id_ujian/".$f['foto'],
  'jenis' => $f['jenis']
];


}

/* ================= DATA UJIAN ================= */
$qUjian=mysqli_query($conn,"
    SELECT u.id,u.nama_ujian,k.nama_kelas,k.paket_id
    FROM ujian u
    JOIN pkbm_taruna_qurani.kelas k ON k.id=u.id_kelas
    WHERE u.id=$id_ujian LIMIT 1
");
$ujian=mysqli_fetch_assoc($qUjian);
if(!$ujian) die("Ujian tidak ditemukan");
$kelas_full=$ujian['nama_kelas'].'-'.chr(64+(int)$ujian['paket_id']);

/* ================= TOTAL SOAL ================= */
$qSoal=mysqli_query($conn,"SELECT COUNT(*) total FROM soal WHERE id_ujian=$id_ujian");
$total_soal=(int)(mysqli_fetch_assoc($qSoal)['total']??0);

/* ================= DATA LIVE ================= */
$qLive=mysqli_query($conn,"
    SELECT
    s.id,
    s.nama,
    ls.status,
    ls.last_active,
    COALESCE(j.jml,0) AS sudah,
    COALESCE(p.total,0) AS pelanggaran,
    COALESCE(p.jenis_pelanggaran,'') AS jenis_pelanggaran,
    w.foto

    FROM smart_cbt.login_siswa ls
    JOIN pkbm_taruna_qurani.siswa s ON s.id=ls.id_siswa
    LEFT JOIN (
        SELECT id_siswa,COUNT(*) jml FROM smart_cbt.jawaban WHERE id_ujian=$id_ujian GROUP BY id_siswa
    ) j ON j.id_siswa=s.id
    LEFT JOIN (
  SELECT 
    id_siswa,
    COUNT(*) total,
    GROUP_CONCAT(DISTINCT jenis_pelanggaran) AS jenis_pelanggaran
  FROM smart_cbt.pelanggaran_ujian
  WHERE id_ujian=$id_ujian
  GROUP BY id_siswa
) p ON p.id_siswa=s.id

    LEFT JOIN (
    SELECT t1.id_siswa, t1.foto
    FROM smart_cbt.webcam_log t1
    JOIN (
        SELECT id_siswa, MAX(waktu) maxwaktu
        FROM smart_cbt.webcam_log
        WHERE id_ujian=$id_ujian
        GROUP BY id_siswa
    ) t2 ON t2.id_siswa=t1.id_siswa AND t2.maxwaktu=t1.waktu
    WHERE t1.id_ujian=$id_ujian
) w ON w.id_siswa=s.id

    WHERE ls.id_ujian=$id_ujian
    ORDER BY s.nama ASC
");

/* ================= SIMPAN KE ARRAY ================= */
$rows=[];
while($r=mysqli_fetch_assoc($qLive)) $rows[]=$r;

$now=time();
function kelasToClass($kelas){ return 'kelas-'.strtolower(str_replace(' ','-',$kelas)); }
?>
<!doctype html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>LIVE STATUS UJIAN</title>
<meta name="viewport" content="width=device-width, initial-scale=1">

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
body{background:#020617;color:#fff}
.logo{height:80px}
.table{background:#fff;color:#000}
.cam-strip{position:fixed;left:0;right:0;bottom:45px;background:#020617;border-top:2px solid #dc3545;padding:6px 8px;z-index:1050}
.cam-scroll{display:flex;gap:10px;overflow-x:auto}
.cam-item{text-align:center;font-size:11px}
.cam-item img{width:80px;height:60px;object-fit:cover;border-radius:6px;border:2px solid #22c55e;transition:border .3s}
.cam-item.curang img{border-color:red}
.footer{position:fixed;left:0;right:0;bottom:0;background:#020617;text-align:right;font-size:13px;color:#aaa;padding:6px 16px;border-top:1px solid #1e293b}

/* ZOOM HOVER */
.cam-item img,.zoomable{cursor:zoom-in;transition: transform .2s}
.cam-item img:hover,.zoomable:hover{transform: scale(1.1);}

/* MODAL */
#camModal{position:fixed;inset:0;background:rgba(0,0,0,.85);display:none;align-items:center;justify-content:center;z-index:3000}
#camModal img{max-width:90vw;max-height:85vh;border-radius:10px;border:4px solid #dc3545;}

/* Tab umum */
.monitor-tabs .nav-link {padding: 4px 8px;font-size:12px;color:#fff;transition: background .3s;}
.monitor-tabs .nav-link.active {background-color: #28a745;border-color:#28a745;color:#fff;}
.tab-wrap{display:flex;align-items:center;gap:4px;white-space:nowrap;}
.tab-badges{display:flex;gap:2px;}
.badge-kelas{background:#334155;color:#e5e7eb;font-size:10px;padding:2px 5px;}
.badge-live{background:#0dcaf0;color:#000;font-size:10px;padding:2px 5px;}
.monitor-tabs .nav-link:hover{opacity:0.8}
.cam-box{
  position:relative;
  background:#020617;
  padding:16px;
  border-radius:12px;
  max-width:95vw;
  text-align:center;
}
.cam-thumb{
  width:60px;
  height:45px;
  object-fit:cover;
  border-radius:6px;
  cursor:zoom-in;
  border:2px solid #22c55e;
}

#camModal img{
  max-width:90vw;
  max-height:70vh; /* ⬅ DITURUNKAN */
  object-fit:contain;
  border-radius:10px;
  border:4px solid #dc3545;
}

.cam-close{
  position:absolute;
  top:10px;
  right:12px;
  width:36px;
  height:36px;
  font-size:22px;
  display:flex;
  align-items:center;
  justify-content:center;
  background:rgba(0,0,0,.6);
  border-radius:50%;
  cursor:pointer;
  z-index:20;
}
.cam-close:hover{
  background:#dc3545;
}
#camModal{
  pointer-events: auto !important;
}
.cam-thumb{
  pointer-events: auto !important;
}

#camModal{
  position:fixed;
  inset:0;
  background:rgba(0,0,0,.85);
  display:none;
  align-items:center;
  justify-content:center;
  z-index:99999;
}

.cam-badges .badge{
  font-size:12px;
  margin:0 3px;
}

.badge-status-ujian{background:#0d6efd}
.badge-status-selesai{background:#198754}
.badge-status-curang{background:#dc3545}

.flash-warning{
  animation: flash 0.6s infinite alternate;
}

@keyframes flash{
  from{box-shadow:0 0 0 rgba(220,53,69,0)}
  to{box-shadow:0 0 20px rgba(220,53,69,0.9)}
}
.cam-thumb{
  max-width:60px;
  border-radius:6px;
  border:2px solid #22c55e;
  cursor:pointer;
}
.table td{
  position:relative;
}



/* Warna otomatis berdasarkan nama kelas */
<?php
$colors=['#1e293b','#2d3748','#374151','#4b5563','#6b7280','#7f8694','#9ca3af','#b0b7c3'];
$i=0;
foreach($ujianAktif as $u){
    $kelasClass=kelasToClass($u['nama_kelas']);
    $color=$colors[$i % count($colors)];
    echo ".{$kelasClass}:not(.active){ background-color: {$color}; }\n";
    $i++;
}

?>
</style>
</head>
<body>

<div class="container-fluid p-4" style="padding-bottom:140px">
<div class="text-center mb-3">
<img src="../assets/logo/<?= $logo ?>" class="logo mb-2">
<h4 class="fw-bold">🔴 LIVE MONITOR UJIAN</h4>
<div class="text-warning"><?= htmlspecialchars($ujian['nama_ujian']) ?> | Kelas <?= $kelas_full ?></div>
</div>

<!-- TAB + BUTTON -->
<div class="d-flex flex-wrap align-items-center mb-3" style="gap:10px;">
  <ul class="nav nav-tabs monitor-tabs flex-grow-1">
  <?php foreach($ujianAktif as $u):
    $kelasTab=$u['nama_kelas'].'-'.chr(64+(int)$u['paket_id']);
    $active=($u['id']==$id_ujian)?'active':'';
    $jml=mysqli_num_rows(mysqli_query($conn,"SELECT 1 FROM smart_cbt.login_siswa WHERE id_ujian=".$u['id']));
    $kelasClass=kelasToClass($u['nama_kelas']);
  ?>
    <li class="nav-item">
      <a class="nav-link <?= $active ?> <?= $kelasClass ?>" href="?ujian_id=<?= $u['id'] ?>">
        <div class="tab-wrap">
          <span class="tab-title">🔴 <?= htmlspecialchars($u['nama_ujian']) ?></span>
          <span class="tab-badges">
            <span class="badge badge-kelas"><?= $kelasTab ?></span>
            <span class="badge badge-live"><?= $jml ?></span>
          </span>
        </div>
      </a>
    </li>
  <?php endforeach ?>
  </ul>
  <div class="ms-2 mt-2 mt-md-0">
    <button id="btnMute" class="btn btn-sm btn-warning">🔊 Suara Aktif</button>
  </div>
</div>

<!-- TABEL STATUS -->
<div class="card shadow">
<table class="table table-bordered align-middle mb-0 table-status-ujian">
<thead class="table-dark text-center">
<tr>
  <th>No</th>
  <th>Nama</th>
  <th>Kelas</th>
  <th>Status</th>
  <th>🚨</th>
  <th>📷</th>
  <th>Progress</th>
  <th>Aksi</th>
</tr>
</thead>
<tbody>
<?php
$no=1;
foreach($rows as $s):

$last   = $s['last_active'] ? strtotime($s['last_active']) : 0;
$persen = $total_soal ? round($s['sudah']/$total_soal*100) : 0;

/* STATUS */
if(!$s['status']){
  $status='BELUM LOGIN'; $badge='secondary';
}elseif($s['status']=='selesai'){
  $status='SELESAI'; $badge='success';
}elseif($last && $now-$last>120){
  $status='TERPUTUS'; $badge='danger';
}elseif(in_array($s['status'],['ujian','mengerjakan'])){
  $status='UJIAN'; $badge='primary';
}else{
  $status='LOGIN'; $badge='info';
}

/* CURANG */
if($s['pelanggaran']>=3 && $status!='SELESAI'){
  $status='⚠ CURANG';
  $badge='danger';
}

$foto = "../uploads/webcam/ujian_$id_ujian/{$s['foto']}";
?>
<tr>

  <!-- NO -->
  <td class="text-center"><?= $no++ ?></td>

  <!-- NAMA -->
  <td><?= htmlspecialchars($s['nama']) ?></td>

  <!-- KELAS -->
  <td class="text-center"><?= $kelas_full ?></td>

  <!-- STATUS -->
  <td class="text-center">
    <span class="badge bg-<?= $badge ?>"><?= $status ?></span>
  </td>

  <!-- 🚨 PELANGGARAN -->
  <td class="text-center">
    <?php if($s['pelanggaran']>0): ?>
      <span class="badge bg-danger"><?= (int)$s['pelanggaran'] ?></span>
    <?php else: ?>
      -
    <?php endif ?>
  </td>

  <!-- 📷 CAMERA -->
  <td class="text-center" id="cam_table_<?= $s['id'] ?>">
    <?php if($s['foto'] && file_exists($foto)): ?>
      <img src="<?= $foto ?>"
     class="cam-thumb"
     onclick='openCam(
        <?= json_encode($foto) ?>,
        <?= json_encode($s["nama"]) ?>,
        <?= json_encode($status) ?>,
        <?= (int)$s["pelanggaran"] ?>,
        <?= (int)$s["id"] ?>,
        <?= json_encode($s["jenis_pelanggaran"] ?? "") ?>
     )'>

    <?php else: ?>
      -
    <?php endif ?>
  </td>

  <!-- PROGRESS -->
  <td>
    <div class="progress" style="height:8px">
      <div class="progress-bar bg-success" style="width:<?= $persen ?>%"></div>
    </div>
    <small><?= $s['sudah'] ?>/<?= $total_soal ?> soal</small>
  </td>

  <!-- AKSI -->
  <td class="text-center">
    <?php if($status!='SELESAI'): ?>
      <a href="force_logout.php?id=<?= $s['id'] ?>&ujian=<?= $id_ujian ?>"
         onclick="return confirm('Paksa logout siswa ini?')"
         class="btn btn-sm btn-danger">
         Keluarkan
      </a>
    <?php else: ?>
      -
    <?php endif ?>
  </td>

</tr>
<?php endforeach ?>
</tbody>
</table>
</div>


<!-- CAMERA STRIP -->
<div class="cam-strip">
<div class="cam-scroll">
<?php foreach($rows as $c):
$cls=$c['pelanggaran']>=3?'curang':'';
$foto="../uploads/webcam/ujian_$id_ujian/{$c['foto']}";
?>
<div class="cam-item <?= $cls ?>" id="cam_strip_<?= $c['id'] ?>">
<img src="<?= ($c['foto'] && file_exists($foto))?$foto:'../assets/no-camera.png' ?>"
onclick="openCam('<?= ($c['foto'] && file_exists($foto))?$foto:'../assets/no-camera.png' ?>','<?= htmlspecialchars($c['nama']) ?>','<?= ($c['pelanggaran']>=3?'⚠ CURANG':'NORMAL') ?>','<?= (int)$c['pelanggaran'] ?>','<?= $c['id'] ?>')">
<div><?= htmlspecialchars($c['nama']) ?></div>
</div>
<?php endforeach ?>
</div>
</div>

<div class="footer">Dikembangkan oleh <b>Bang Zae</b></div>

<!-- AUDIO -->
<audio id="sfx_tab" src="../assets/audio/tab.mp3"></audio>
<audio id="sfx_cam" src="../assets/audio/camera.mp3"></audio>
<audio id="sfx_berat" src="../assets/audio/berat.mp3"></audio>

<script>
const fotoPelanggaran=<?= json_encode($fotoLog) ?>;
let slideIndex=0;
let currentFotos=[];
let lastCheck = 0; // MULAI DARI 0
let modalSiswaId = null;
let modalJenis   = '';

function openCam(src,nama,status,pelanggaran,idSiswa,jenis=""){
    modalSiswaId = idSiswa;

    currentFotos = Array.isArray(fotoPelanggaran[idSiswa]) && fotoPelanggaran[idSiswa].length
        ? fotoPelanggaran[idSiswa]
        : [{ foto: src, jenis: '' }];

    slideIndex = currentFotos.length - 1;
    showSlide();

    document.getElementById('camInfo').innerHTML =
        `<div class="fw-bold fs-6">${nama}</div>
         <small id="fotoJenis" class="text-warning fw-bold"></small>`;

    const badgeStatus = document.getElementById('badgeStatus');
    badgeStatus.className = 'badge';
    if(status.includes('CURANG')){
        badgeStatus.classList.add('badge-status-curang');
    }else if(status === 'SELESAI'){
        badgeStatus.classList.add('badge-status-selesai');
    }else{
        badgeStatus.classList.add('badge-status-ujian');
    }
    badgeStatus.innerText = status;

    document.getElementById('badgePelanggaran').innerText =
        `🚨 ${pelanggaran} Pelanggaran | 📷 ${currentFotos.length} Foto`;

    const badgeJenis = document.getElementById('badgeJenis');
    if(jenis){
        badgeJenis.classList.remove('d-none');
        badgeJenis.innerText = jenis.toUpperCase();
        document.getElementById('fotoJenis').innerText =
            '⚠ ' + jenis.toUpperCase();
    }else{
        badgeJenis.classList.add('d-none');
        document.getElementById('fotoJenis').innerText = '';
    }

    const modal = document.getElementById('camModal');
modal.style.display = 'flex';
modal.style.opacity = '1';
modal.style.zIndex = '99999';

}


function showSlide(){
    if(!currentFotos.length) return;

    const fotoObj = currentFotos[slideIndex];

    document.getElementById('camZoom').src = fotoObj.foto;

    const jenisEl = document.getElementById('fotoJenis');
    if(jenisEl){
        jenisEl.innerText = fotoObj.jenis
            ? '⚠ ' + fotoObj.jenis.toUpperCase()
            : '';
    }
}


function nextFoto(){slideIndex=(slideIndex+1)%currentFotos.length;showSlide();}
function prevFoto(){slideIndex=(slideIndex-1+currentFotos.length)%currentFotos.length;showSlide();}
function closeCam(){document.getElementById('camModal').style.display='none';}

document.addEventListener('DOMContentLoaded',()=>{
const btn=document.getElementById('btnMute');
const sfx_tab=document.getElementById('sfx_tab');
const sfx_cam=document.getElementById('sfx_cam');
const sfx_berat=document.getElementById('sfx_berat');

let mute=localStorage.getItem('mute_pengawas')==='1';
let audioUnlocked=false;
let ttsInitPlayed=false;
let femaleVoice=null;
const cooldown={}; 
const COOLDOWN_TIME=15000; 
const logoutLock={};

function initVoice(){
    const voices=speechSynthesis.getVoices();
    femaleVoice=voices.find(v=>v.lang==='id-ID' && v.name.toLowerCase().includes('female'))||voices.find(v=>v.lang==='id-ID')||null;
}
speechSynthesis.onvoiceschanged=initVoice;
initVoice();

function updateMuteUI(){btn.innerHTML=mute?'🔕 Suara Dimatikan':'🔊 Suara Aktif'; btn.className=mute?'btn btn-sm btn-secondary':'btn btn-sm btn-warning';}
function unlockAudio(){
    if(audioUnlocked) return;
    [sfx_tab,sfx_cam,sfx_berat].forEach(a=>{if(!a) return;a.muted=false;a.currentTime=0;a.play().then(()=>{a.pause();a.currentTime=0}).catch(()=>{});});
    if(!mute && !ttsInitPlayed){
        const initMsg=new SpeechSynthesisUtterance("Sistem pengawasan aktif.");
        initMsg.lang='id-ID'; initMsg.rate=0.95; initMsg.pitch=1.1; 
        if(femaleVoice) initMsg.voice=femaleVoice;
        speechSynthesis.speak(initMsg);
        ttsInitPlayed=true;
    }
    audioUnlocked=true;updateMuteUI();
}

btn.onclick=()=>{unlockAudio(); mute=!mute; localStorage.setItem('mute_pengawas',mute?'1':'0'); updateMuteUI();}
function playSFX(audio){if(mute||!audio||!audioUnlocked) return; audio.currentTime=0; audio.play().catch(()=>{});}
function speak(text,rate=1,pitch=1){if(!audioUnlocked) unlockAudio(); if(mute) return; const msg=new SpeechSynthesisUtterance(text); msg.lang='id-ID'; msg.rate=rate; msg.pitch=pitch; if(femaleVoice) msg.voice=femaleVoice; speechSynthesis.cancel(); speechSynthesis.speak(msg);}

function fotoSudahAda(id, foto){
  return Array.isArray(fotoPelanggaran[id]) &&
         fotoPelanggaran[id].some(f => f.foto === foto);
}


async function cekPelanggaran(){
  try{
    const res = await fetch(
      "cek_pelanggaran.php?ujian=<?= $id_ujian ?>&last=" + lastCheck,
      { cache: "no-store" }
    );

    const data = await res.json();
    if(!data || !data.ada || !Array.isArray(data.pelanggaran)) return;

    // ⬅️ timestamp dari SERVER
    if(data.last_time) lastCheck = data.last_time;

    data.pelanggaran.forEach(p => {

      /* ================= FOTO (APPEND, BUKAN TIMPA) ================= */
      if(Array.isArray(p.fotoBaru) && p.fotoBaru.length){

        if(!Array.isArray(fotoPelanggaran[p.id_siswa])){
          fotoPelanggaran[p.id_siswa] = [];
        }

        p.fotoBaru.forEach(f=>{
  if(!fotoSudahAda(p.id_siswa, f)){
    fotoPelanggaran[p.id_siswa].push({
      foto: f,
      jenis: p.jenis || ''
    });
  }
});


      }

      /* ================= UPDATE CAM STRIP ================= */
      const camDiv = document.getElementById("cam_strip_"+p.id_siswa);
      if(camDiv){
        camDiv.classList.add('curang');
        setTimeout(()=>camDiv.classList.remove('curang'),3000);

        const img = camDiv.querySelector('img');
        if(img && p.fotoBaru?.length){
          img.src = p.fotoBaru[p.fotoBaru.length-1];
        }
      }

      /* ================= UPDATE FOTO TABEL ================= */
      const td = document.getElementById("cam_table_"+p.id_siswa);
      if(td){
        const img = td.querySelector('img');
        if(img && p.fotoBaru?.length){
          img.src = p.fotoBaru[p.fotoBaru.length-1];
        }
      }

      /* ================= UPDATE MODAL JIKA TERBUKA ================= */
      const camModal = document.getElementById('camModal');
      if(modalSiswaId === p.id_siswa && camModal.style.display === 'flex'){

        if(p.fotoBaru?.length){
          currentFotos = fotoPelanggaran[p.id_siswa];
          slideIndex = currentFotos.length - 1;
          showSlide();
        }

        // status
        const badgeStatus = document.getElementById('badgeStatus');
        badgeStatus.className = 'badge badge-status-curang';
        badgeStatus.innerText = '⚠ CURANG';

        // jumlah
        document.getElementById('badgePelanggaran').innerText =
`🚨 ${p.total} Pelanggaran | 📷 ${fotoPelanggaran[p.id_siswa].length} Foto`;



        // jenis
        const badgeJenis = document.getElementById('badgeJenis');
        if(p.jenis){
          badgeJenis.classList.remove('d-none');
          badgeJenis.innerText = p.jenis.toUpperCase();
          document.getElementById('fotoJenis').innerText =
            '⚠ ' + p.jenis.toUpperCase();
        }

        const zoom = document.getElementById('camZoom');
        zoom.classList.add('flash-warning');
        setTimeout(()=>zoom.classList.remove('flash-warning'),2000);
      }

      /* ================= AUDIO + TTS (AMAN) ================= */
      const key = p.id_siswa+"_"+p.jenis;
      const now = Date.now();
      if(cooldown[key] && now - cooldown[key] < COOLDOWN_TIME) return;
      cooldown[key] = now;

      switch(p.jenis){
        case "tab":
          playSFX(sfx_tab);
          speak(`Pelanggaran. ${p.nama}, pindah tab.`);
          break;
        case "kamera":
          playSFX(sfx_cam);
          speak(`Perhatian. Kamera ${p.nama} tidak aktif.`);
          break;
        case "wajah":
          playSFX(sfx_cam);
          speak(`Peringatan. Wajah ${p.nama} tidak terdeteksi.`);
          break;
        case "multi":
          if(logoutLock[p.id_siswa]) return;
          logoutLock[p.id_siswa] = true;
          playSFX(sfx_berat);
          speak(`Pelanggaran berat. ${p.nama}. Ujian dihentikan.`);
          fetch("force_logout.php?id="+p.id_siswa+"&ujian=<?= $id_ujian ?>");
          break;
      }

    });

  }catch(e){
    console.warn("Gagal cek pelanggaran:", e);
  }
}

setInterval(cekPelanggaran,800);

});
</script>


<div id="camModal">
  <div class="cam-box">

    <!-- CLOSE -->
    <span class="cam-close" onclick="closeCam()">✖</span>

    <!-- FOTO -->
    <img id="camZoom">

    <!-- NAMA -->
    <div id="camInfo" class="mt-2 text-center"></div>

    <!-- STATUS -->
    <div class="mt-1 text-center">
      <span id="badgeStatus" class="badge"></span>
    </div>

    <!-- JUMLAH PELANGGARAN -->
    <div class="mt-1 text-center">
      <span id="badgePelanggaran" class="badge bg-danger"></span>
    </div>

    <!-- JENIS PELANGGARAN -->
    <div class="mt-1 text-center">
      <span id="badgeJenis"
            class="badge bg-warning text-dark d-none"></span>
    </div>

    <!-- NAV FOTO -->
    <div class="d-flex justify-content-between mt-3">
      <button class="btn btn-light btn-sm" onclick="prevFoto()">⬅</button>
      <button class="btn btn-light btn-sm" onclick="nextFoto()">➡</button>
    </div>

  </div>
</div>


</body>
</html>
