<?php
require __DIR__ . '/../config/database.php';
session_start();

/* ================= AUTH ================= */
if (empty($_SESSION['login']) || ($_SESSION['user']['role'] ?? '') !== 'admin') {
    header("Location: ../auth/login.php");
    exit;
}
/* ================= PROFIL SEKOLAH ================= */
$nama_aplikasi = 'SMART CBT';
$nama_sekolah  = 'SEKOLAH';
$logo = 'default.png';

$tables = ['profil_sekolah','profil_aplikasi','setting','sekolah'];
foreach ($tables as $t) {
    $c = mysqli_query($conn,"SHOW TABLES LIKE '$t'");
    if ($c && mysqli_num_rows($c)) {
        $q = mysqli_query($conn,"SELECT * FROM `$t` LIMIT 1");
        if ($q && mysqli_num_rows($q)) {
            $s = mysqli_fetch_assoc($q);
            $nama_aplikasi = $s['nama_aplikasi'] ?? $nama_aplikasi;
            $nama_sekolah  = $s['nama_sekolah'] ?? $nama_sekolah;
            $logo          = $s['logo'] ?? $logo;
        }
        break;
    }
}
if (!file_exists(__DIR__."/../assets/logo/$logo")) $logo='default.png';

/* ================= HELPER ================= */
function esc($c,$s){ return mysqli_real_escape_string($c,trim($s)); }

/* ================= TAMBAH ================= */
if(isset($_POST['simpan'])){
    mysqli_query($conn,"INSERT INTO kelas VALUES(
        NULL,
        '".esc($conn,$_POST['nama_kelas'])."'
    )");
    header("Location:kelas.php"); exit;
}

/* ================= UPDATE ================= */
if(isset($_POST['update'])){
    $id=(int)$_POST['id'];
    mysqli_query($conn,"UPDATE kelas SET
        nama_kelas='".esc($conn,$_POST['nama_kelas'])."'
        WHERE id=$id
    ");
    header("Location:kelas.php"); exit;
}

/* ================= HAPUS ================= */
if(isset($_POST['hapus'])){
    $id=(int)$_POST['hapus_id'];
    mysqli_query($conn,"DELETE FROM kelas WHERE id=$id");
    header("Location:kelas.php"); exit;
}

/* ================= DATA ================= */
$kelas=mysqli_query($conn,"SELECT * FROM kelas ORDER BY nama_kelas");
?>
<!doctype html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Data Kelas</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">
<style>
body{background:#f4f6f9}
.sidebar{width:260px;min-height:100vh;background:#1f2937;color:#fff;position:fixed}
.brand{padding:16px;background:#111827;display:flex;gap:12px;align-items:center}
.brand img{width:36px}
.sidebar a{color:#cbd5e1;padding:10px 16px;display:block;text-decoration:none}
.sidebar a:hover,.sidebar a.active{background:#2563eb;color:#fff}
.submenu a{padding-left:42px;font-size:14px}
.content{margin-left:260px;padding:24px}
/* FOOTER */
.footer-fixed{
  position:fixed;
  bottom:10px;
  right:16px;
  font-size:13px;
  color:#000;
}
</style>
</head>
<body>

<!-- SIDEBAR -->
<div class="sidebar">
  <div class="brand">
    <img src="../assets/logo/<?= htmlspecialchars($logo) ?>">
    <div>
      <b><?= htmlspecialchars($nama_aplikasi) ?></b><br>
      <small><?= htmlspecialchars($nama_sekolah) ?></small>
    </div>
  </div>
  <a href="dashboard.php"><i class="bi bi-speedometer2 me-2"></i> Dashboard</a>
  <a data-bs-toggle="collapse" href="#master">
    <i class="bi bi-database me-2"></i> Master Data
    <i class="bi bi-chevron-down float-end"></i>
  </a>
  <div class="collapse show submenu" id="master">
    <a href="kelas.php">🏫 Kelas</a>
    <a href="mapel.php">📘 Mata Pelajaran</a>
    <a href="siswa.php">👨‍🎓 Siswa</a>
    <a href="tahun.php">📅 Tahun Pelajaran</a>
  </div>
  <a data-bs-toggle="collapse" href="#ujian">
  <i class="bi bi-pencil-square me-2"></i> Ujian
  <i class="bi bi-chevron-down float-end"></i>
</a>
<div class="collapse submenu" id="ujian">
  <a href="cetak_kartu_kelas.php">🖨 Cetak Kartu</a>
  <a href="paket.php">📦 Paket Ujian</a>
  <a href="ujian.php">📝 Daftar Ujian</a>
  <a href="token.php">🔑 Token</a>
</div>


  <a data-bs-toggle="collapse" href="#hasil">
  <i class="bi bi-bar-chart-line me-2"></i> Hasil
  <i class="bi bi-chevron-down float-end"></i>
</a>

<div class="collapse submenu" id="hasil">
  <a href="hasil.php">📊 Nilai</a>
  <a href="ranking.php">🏆 Ranking</a>
  <a href="laporan_jawaban.php">📝 Jawaban Siswa</a>
</div>


  <a href="../auth/logout.php">
    <i class="bi bi-box-arrow-right me-2"></i> Logout
  </a>
</div>


<!-- ================= CONTENT ================= -->
<div class="content">
<h4>Data Kelas</h4>

<button class="btn btn-primary mb-3" data-bs-toggle="modal" data-bs-target="#tambah">
<i class="bi bi-plus"></i> Tambah Kelas
</button>

<table class="table table-bordered bg-white">
<tr class="table-light text-center">
<th width="60">No</th>
<th>Nama Kelas</th>
<th width="150">Aksi</th>
</tr>

<?php $no=1; while($k=mysqli_fetch_assoc($kelas)): ?>
<tr>
<td class="text-center"><?= $no++ ?></td>
<td><?= $k['nama_kelas'] ?></td>
<td class="text-center">
<button class="btn btn-warning btn-sm" data-bs-toggle="modal" data-bs-target="#edit<?= $k['id'] ?>">
<i class="bi bi-pencil"></i>
</button>
<button class="btn btn-danger btn-sm" data-bs-toggle="modal" data-bs-target="#hapus<?= $k['id'] ?>">
<i class="bi bi-trash"></i>
</button>
</td>
</tr>
<?php endwhile; ?>
</table>
</div>

<!-- ================= MODAL TAMBAH ================= -->
<div class="modal fade" id="tambah">
<div class="modal-dialog modal-sm">
<form method="post" class="modal-content p-3">
<h5 class="mb-3">Tambah Kelas</h5>
<input name="nama_kelas" class="form-control mb-3" placeholder="Nama Kelas" required>
<button name="simpan" class="btn btn-success w-100">Simpan</button>
</form>
</div>
</div>

<?php
mysqli_data_seek($kelas,0);
while($k=mysqli_fetch_assoc($kelas)):
?>

<!-- ================= MODAL EDIT ================= -->
<div class="modal fade" id="edit<?= $k['id'] ?>">
<div class="modal-dialog modal-sm">
<form method="post" class="modal-content p-3">
<input type="hidden" name="id" value="<?= $k['id'] ?>">
<h5 class="mb-3">Edit Kelas</h5>
<input name="nama_kelas" class="form-control mb-3" value="<?= $k['nama_kelas'] ?>" required>
<button name="update" class="btn btn-primary w-100">Update</button>
</form>
</div>
</div>

<!-- ================= MODAL HAPUS ================= -->
<div class="modal fade" id="hapus<?= $k['id'] ?>">
<div class="modal-dialog modal-sm">
<form method="post" class="modal-content p-3 text-center">
<input type="hidden" name="hapus_id" value="<?= $k['id'] ?>">
<p>Hapus kelas <b><?= $k['nama_kelas'] ?></b>?</p>
<button name="hapus" class="btn btn-danger w-100">Hapus</button>
</form>
</div>
</div>

<?php endwhile; ?>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
<!-- ===== FOOTER ===== -->
<div class="footer-fixed">
  Dibuat Oleh : <b>Bang Zae</b>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
