<?php
session_start();
require "koneksi.php";

/* ================= AUTH ================= */
if (empty($_SESSION['login_tutor'])) {
  header("Location: login.php");
  exit;
}

$tutor_id = (int)($_SESSION['tutor_id'] ?? 0);

/* ================= DATA RIWAYAT ================= */
$data = [];

$q = mysqli_query($conn, "
  SELECT 
    id,
    tanggal,
    waktu,
    waktu_pulang,
    foto_masuk,
    foto_pulang,
    latitude_masuk,
    longitude_masuk,
    latitude_pulang,
    longitude_pulang,
    alamat,
    status
  FROM presensi_guru
  WHERE tutor_id = '$tutor_id'
  ORDER BY tanggal DESC
  LIMIT 50
");

if ($q) {
  while ($r = mysqli_fetch_assoc($q)) {
    $data[] = $r;
  }
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>History Presensi</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<style>
body{
  margin:0;
  font-family:'Segoe UI',sans-serif;
  background:#f3f4f8;
  padding-bottom:80px
}

/* HEADER */
.topbar{
  background:linear-gradient(135deg,#d4af37,#f6e27a);
  color:#222;padding:14px 16px;
  display:flex;align-items:center;justify-content:space-between
}

/* LIST */
.list{
  margin:12px;
}
.card{
  background:#fff;
  border-radius:16px;
  padding:12px;
  margin-bottom:10px;
  box-shadow:0 6px 15px rgba(0,0,0,.08);
  font-size:13px
}
.card .row{
  display:flex;
  justify-content:space-between;
  margin-bottom:6px
}
.badge{
  padding:2px 8px;
  border-radius:10px;
  font-size:11px;
  font-weight:600
}
.badge.hadir{background:#2ecc71;color:#fff}
.badge.izin{background:#ffb300;color:#222}
.badge.sakit{background:#3498db;color:#fff}
.badge.cuti{background:#9b59b6;color:#fff}

.time a{
  color:#d4af37;
  font-weight:600;
  text-decoration:none;
  margin-right:8px
}

/* POPUP */
.popup{
  position:fixed;inset:0;
  background:rgba(0,0,0,.6);
  display:none;
  align-items:center;
  justify-content:center;
  z-index:999
}
.popup-box{
  background:#fff;
  color:#000;
  border-radius:16px;
  padding:16px;
  width:90%;
  max-width:340px;
  text-align:center
}
.popup-box img{
  width:100%;
  border-radius:12px;
  margin-bottom:10px
}
.popup-box button{
  background:linear-gradient(135deg,#d4af37,#f6e27a);
  border:none;
  padding:8px 14px;
  border-radius:10px;
  font-weight:700
}

/* FOOTER */
.footer{
  position:fixed;
  bottom:0;left:0;right:0;
  background:#fff;border-top:1px solid #ddd;
  display:flex;justify-content:space-around;
  padding:6px 0
}
.footer a{
  text-decoration:none;
  font-size:11px;
  color:#555;
  text-align:center
}
.footer span{
  display:block;
  font-size:18px
}
.footer a.active{
  color:#f57c00;
  font-weight:600
}
</style>
</head>

<body>

<!-- POPUP -->
<div class="popup" id="popup">
  <div class="popup-box">
    <h4 id="popup-title"></h4>
    <img id="popup-img" src="">
    <p id="popup-info"></p>
    <button onclick="closePopup()">Tutup</button>
  </div>
</div>

<!-- HEADER -->
<div class="topbar">
  <span>📜 History Presensi</span>
  <span></span>
</div>

<!-- LIST -->
<div class="list">
<?php if(empty($data)): ?>
  <div class="card" style="text-align:center;color:#777">
    Belum ada data presensi
  </div>
<?php else: ?>
  <?php foreach($data as $r): 
    $tgl = date('d/m/Y', strtotime($r['tanggal']));
    $jam_masuk  = $r['waktu'] ? substr($r['waktu'],0,5) : '-';
    $jam_pulang = $r['waktu_pulang'] ? substr($r['waktu_pulang'],0,5) : '-';
  ?>
  <div class="card">
    <div class="row">
      <b><?= $tgl ?></b>
      <span class="badge <?= htmlspecialchars($r['status']) ?>">
        <?= ucfirst($r['status']) ?>
      </span>
    </div>

    <div class="row time">
      <div>
        Masuk:
        <?php if($r['foto_masuk']): ?>
          <a href="javascript:void(0)" 
             onclick="showPopup('masuk', <?= htmlspecialchars(json_encode($r)) ?>)">
             <?= $jam_masuk ?>
          </a>
        <?php else: ?>
          -
        <?php endif; ?>
      </div>

      <div>
        Pulang:
        <?php if($r['foto_pulang']): ?>
          <a href="javascript:void(0)" 
             onclick="showPopup('pulang', <?= htmlspecialchars(json_encode($r)) ?>)">
             <?= $jam_pulang ?>
          </a>
        <?php else: ?>
          -
        <?php endif; ?>
      </div>
    </div>
  </div>
  <?php endforeach; ?>
<?php endif; ?>
</div>

<!-- FOOTER -->
<div class="footer">
  <a href="dashboard.php"><span>🏠</span>Home</a>
  <a href="presensi.php"><span>📸</span>Presensi</a>
  <a href="izin.php"><span>📝</span>Izin</a>
  <a class="active"><span>📜</span>History</a>
  <a href="profil.php"><span>👤</span>Profil</a>
</div>

<script>
function showPopup(mode, data){
  const title = document.getElementById("popup-title");
  const img   = document.getElementById("popup-img");
  const info  = document.getElementById("popup-info");

  title.innerText = mode === "masuk" ? "Absen Masuk" : "Absen Pulang";

  let foto   = mode === "masuk" ? data.foto_masuk : data.foto_pulang;
  let jam    = mode === "masuk" ? data.waktu : data.waktu_pulang;
  let lat    = mode === "masuk" ? data.latitude_masuk : data.latitude_pulang;
  let lng    = mode === "masuk" ? data.longitude_masuk : data.longitude_pulang;

  if(foto){
    img.src = "uploads/presensi/" + foto;
    img.style.display = "block";
  } else {
    img.style.display = "none";
  }

  info.innerHTML = `
    <b>Jam:</b> ${jam ?? '-'}<br>
    <b>Alamat:</b><br>${data.alamat ?? '-'}<br><br>
    <b>Koordinat:</b><br>${lat ?? '-'}, ${lng ?? '-'}
  `;

  document.getElementById("popup").style.display = "flex";
}

function closePopup(){
  document.getElementById("popup").style.display = "none";
}
</script>

</body>
</html>
