<?php
session_start();
require '../../config/database.php';

/* ================= CEK LOGIN ================= */
if (
    empty($_SESSION['login']) ||
    ($_SESSION['user']['role'] ?? '') !== 'tutor'
){
    header("Location: ../../auth/login.php");
    exit;
}

$tutor_id = (int) ($_SESSION['user']['id'] ?? 0);

if (!$conn) {
    die("Koneksi database gagal.");
}

/* ================= AUTO UPDATE STATUS ================= */
mysqli_query($conn,"
UPDATE zoom_meeting 
SET status='live'
WHERE tutor_id='$tutor_id'
AND NOW() BETWEEN waktu_mulai AND waktu_selesai
AND status='scheduled'
");

mysqli_query($conn,"
UPDATE zoom_meeting 
SET status='selesai'
WHERE tutor_id='$tutor_id'
AND NOW() > waktu_selesai
AND status!='selesai'
");

/* ================= TAMBAH ================= */
if(isset($_POST['tambah_zoom'])){
    $kelas_id  = (int)$_POST['kelas_id'];
    $mapel_id  = (int)$_POST['mapel_id'];
    $mulai     = $_POST['waktu_mulai'];
    $selesai   = $_POST['waktu_selesai'];

    mysqli_query($conn,"INSERT INTO zoom_meeting
    (tutor_id,kelas_id,mapel_id,waktu_mulai,waktu_selesai,status)
    VALUES('$tutor_id','$kelas_id','$mapel_id','$mulai','$selesai','scheduled')");

    header("Location: index.php");
    exit;
}

/* ================= UPDATE ================= */
if(isset($_POST['update_zoom'])){
    $id        = (int)$_POST['id'];
    $kelas_id  = (int)$_POST['kelas_id'];
    $mapel_id  = (int)$_POST['mapel_id'];
    $mulai     = $_POST['waktu_mulai'];
    $selesai   = $_POST['waktu_selesai'];

    mysqli_query($conn,"UPDATE zoom_meeting SET
    kelas_id='$kelas_id',
    mapel_id='$mapel_id',
    waktu_mulai='$mulai',
    waktu_selesai='$selesai'
    WHERE id='$id' AND tutor_id='$tutor_id'");

    header("Location: index.php");
    exit;
}

/* ================= HAPUS ================= */
if(isset($_GET['hapus'])){
    $id=(int)$_GET['hapus'];
    mysqli_query($conn,"DELETE FROM zoom_meeting 
    WHERE id='$id' AND tutor_id='$tutor_id'");
    header("Location: index.php");
    exit;
}

/* ================= DATA ================= */
$query = mysqli_query($conn,"
SELECT 
z.*,
CONCAT(k.nama_kelas,'-',IFNULL(p.nama,'')) AS nama_kelas,
m.nama_mapel
FROM zoom_meeting z
JOIN kelas k ON z.kelas_id = k.id
LEFT JOIN paket p ON k.paket_id = p.id
LEFT JOIN mapel m ON z.mapel_id = m.id
WHERE z.tutor_id = '$tutor_id'
ORDER BY z.waktu_mulai DESC
");

$qKelas = mysqli_query($conn,"
SELECT 
k.id,
CONCAT(k.nama_kelas,'-',IFNULL(p.nama,'')) AS nama_kelas
FROM kelas k
LEFT JOIN paket p ON k.paket_id=p.id
ORDER BY k.nama_kelas
");

$mapel = mysqli_query($conn,"SELECT * FROM mapel ORDER BY nama_mapel ASC");
?>

<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Manajemen Live Class</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">

<style>
body{background:#f4f6f9;font-size:14px}
.main-content{margin-left:260px;padding:25px}
@media(max-width:991px){.main-content{margin-left:0}}
.card-zoom{border:none;border-radius:18px;box-shadow:0 5px 15px rgba(0,0,0,.05);transition:.3s}
.card-zoom:hover{transform:translateY(-4px)}
.badge-live{background:#dc3545}
.badge-scheduled{background:#ffc107;color:#000}
.badge-selesai{background:#198754}
</style>
</head>
<body>

<?php require_once dirname(__DIR__) . '/sidebar.php'; ?>

<button class="btn btn-primary d-lg-none m-2"
        data-bs-toggle="offcanvas"
        data-bs-target="#sidebarTutor">
    <i class="bi bi-list"></i>
</button>

<div class="main-content">

<div class="d-flex justify-content-between align-items-center mb-4">
<h5 class="fw-bold mb-0">
<i class="bi bi-camera-video-fill text-primary"></i> Manajemen Live Class
</h5>
<button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#modalZoom">
<i class="bi bi-plus-circle"></i> Buat Jadwal
</button>
</div>

<div class="row">
<?php while($z = mysqli_fetch_assoc($query)):

$status = $z['status'];
$badge  = $status=='live' ? 'badge-live' :
          ($status=='scheduled' ? 'badge-scheduled' : 'badge-selesai');
$label  = $status=='live' ? 'LIVE' :
          ($status=='scheduled' ? 'Terjadwal' : 'Selesai');
?>

<div class="col-md-6 col-lg-4 mb-4">
<div class="card card-zoom h-100">
<div class="card-body">

<div class="d-flex justify-content-between mb-2">
<span class="badge <?= $badge ?>"><?= $label ?></span>
<small><?= date('d M Y H:i', strtotime($z['waktu_mulai'])) ?></small>
</div>

<h6 class="fw-bold mb-1">
<?= htmlspecialchars($z['nama_mapel'] ?? '-') ?>
</h6>

<p class="text-muted small mb-2">
<i class="bi bi-building"></i>
<?= htmlspecialchars($z['nama_kelas']) ?>
</p>

<p class="small mb-3">
<i class="bi bi-clock"></i>
<?= date('H:i', strtotime($z['waktu_mulai'])) ?> -
<?= date('H:i', strtotime($z['waktu_selesai'])) ?>
</p>

<?php if($status=='live'): ?>
<a href="live_tutor.php?id=<?= $z['id'] ?>"
class="btn btn-danger btn-sm w-100 mb-2">
<i class="bi bi-camera-video"></i> Masuk Kelas
</a>
<?php endif; ?>


<div class="d-flex gap-2">
<button class="btn btn-warning btn-sm w-100"
onclick="editZoom(
'<?= $z['id'] ?>',
'<?= $z['kelas_id'] ?>',
'<?= $z['mapel_id'] ?>',
'<?= $z['waktu_mulai'] ?>',
'<?= $z['waktu_selesai'] ?>'
)">
<i class="bi bi-pencil"></i>
</button>

<a href="?hapus=<?= $z['id'] ?>"
onclick="return confirm('Yakin hapus jadwal ini?')"
class="btn btn-danger btn-sm w-100">
<i class="bi bi-trash"></i>
</a>
</div>

</div>
</div>
</div>

<?php endwhile; ?>
</div>
</div>

<!-- MODAL -->
<div class="modal fade" id="modalZoom">
<div class="modal-dialog">
<div class="modal-content">
<form method="POST">
<div class="modal-header">
<h5 class="modal-title">Form Jadwal</h5>
<button type="button" class="btn-close" data-bs-dismiss="modal"></button>
</div>

<div class="modal-body">
<input type="hidden" name="id" id="zoom_id">

<div class="mb-2">
<label>Kelas</label>
<select name="kelas_id" id="kelas_id" class="form-control" required>
<option value="">-- Pilih Kelas --</option>
<?php while($k=mysqli_fetch_assoc($qKelas)): ?>
<option value="<?= $k['id'] ?>">
<?= htmlspecialchars($k['nama_kelas']) ?>
</option>
<?php endwhile; ?>
</select>
</div>

<div class="mb-2">
<label>Mapel</label>
<select name="mapel_id" id="mapel_id" class="form-control" required>
<option value="">-- Pilih Mapel --</option>
<?php while($m=mysqli_fetch_assoc($mapel)): ?>
<option value="<?= $m['id'] ?>">
<?= htmlspecialchars($m['nama_mapel']) ?>
</option>
<?php endwhile; ?>
</select>
</div>

<div class="mb-2">
<label>Waktu Mulai</label>
<input type="datetime-local" name="waktu_mulai" id="waktu_mulai" class="form-control" required>
</div>

<div class="mb-2">
<label>Waktu Selesai</label>
<input type="datetime-local" name="waktu_selesai" id="waktu_selesai" class="form-control" required>
</div>
</div>

<div class="modal-footer">
<button type="submit" name="tambah_zoom" id="btnTambah" class="btn btn-primary">Simpan</button>
<button type="submit" name="update_zoom" id="btnUpdate" class="btn btn-warning d-none">Update</button>
</div>
</form>
</div>
</div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

<script>
function editZoom(id,kelas,mapel,mulai,selesai){
var modal = new bootstrap.Modal(document.getElementById('modalZoom'));
modal.show();
document.getElementById('zoom_id').value=id;
document.getElementById('kelas_id').value=kelas;
document.getElementById('mapel_id').value=mapel;
document.getElementById('waktu_mulai').value=mulai.replace(' ','T');
document.getElementById('waktu_selesai').value=selesai.replace(' ','T');
document.getElementById('btnTambah').classList.add('d-none');
document.getElementById('btnUpdate').classList.remove('d-none');
}
</script>

</body>
</html>
