<?php
session_start();
require '../config/database.php';

/* ================= SECURITY ================= */
if (empty($_SESSION['login']) || ($_SESSION['user']['role'] ?? '') !== 'tutor') {
    header("Location: ../auth/login.php");
    exit;
}

/* ================= HELPER FORMAT ================= */
function formatKelasPaket($kelas, $paket){
    if(!$kelas) return '-';
    if($paket) return $kelas . '-' . strtoupper($paket);
    return strtoupper($kelas);
}

/* ================= DATA USER ================= */
$tutor_id = (int)($_SESSION['user']['id'] ?? 0);
$nama     = $_SESSION['user']['nama'] ?? '';

/* ================= TAHUN AJARAN AKTIF ================= */
$qta = mysqli_query($conn,"SELECT id,tahun FROM tahun_ajaran WHERE status='aktif' LIMIT 1");
$tahun = mysqli_fetch_assoc($qta);
if(!$tahun) die('Tahun ajaran aktif belum diset');

$tahun_id   = (int)$tahun['id'];
$tahun_nama = $tahun['tahun'];
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Materi Tutor</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
<style>
body{background:#f4f6f9;font-size:14px}
.main-content{margin-left:260px;padding:80px 20px}
@media(max-width:991px){.main-content{margin-left:0;padding-top:70px}}
.topbar{position:fixed;top:0;left:260px;right:0;height:56px;background:#fff;border-bottom:1px solid #ddd;z-index:1020;display:flex;align-items:center;padding:0 16px}
@media(max-width:991px){.topbar{left:0}}
.card-custom{background:#fff;border-radius:18px;box-shadow:0 8px 20px rgba(0,0,0,.08)}
/* ===== FOOTER MOBILE MENU ===== */
.footer-mobile{
 display:none;
}

@media(max-width:991px){
 .footer-mobile{
  display:flex;
  position:fixed;
  bottom:0;
  left:0;
  right:0;
  background:#fff;
  border-top:1px solid #ddd;
  z-index:999;
 }

 .footer-mobile a{
  flex:1;
  text-align:center;
  padding:8px 4px;
  font-size:11px;
  color:#666;
  text-decoration:none;
 }

 .footer-mobile a i{
  font-size:18px;
  display:block;
 }

 .footer-mobile a.active{
  color:#0d6efd;
  font-weight:600;
 }

 .footer-mobile a.active i{
  color:#0d6efd;
 }

 /* kasih ruang supaya konten ga ketutup footer */
 body{padding-bottom:65px}
}

</style>
</head>
<!-- FOOTER MOBILE -->
<div class="footer-mobile d-lg-none">

 <a href="profil.php" class="active">
  <i class="bi bi-person-circle"></i>
  Profil
 </a>

 <a href="absen_list_cetak.php">
  <i class="bi bi-clipboard-check"></i>
  Absen
 </a>

 <a href="materi.php">
  <i class="bi bi-journal-text"></i>
  Materi
 </a>

 <a href="elearning.php">
  <i class="bi bi-laptop"></i>
  E-Learning
 </a>

 <a href="absen_dan_jawaban.php">
  <i class="bi bi-ui-checks-grid"></i>
  Jawaban
 </a>

</div>

<body>

<div class="topbar">
<button class="btn btn-outline-primary d-lg-none" data-bs-toggle="offcanvas" data-bs-target="#sidebarTutor">
<i class="bi bi-list"></i>
</button>
<span class="fw-semibold ms-2">
Materi Pembelajaran <small class="text-muted">(<?= htmlspecialchars($tahun_nama) ?>)</small>
</span>
<span class="ms-auto small"><?= htmlspecialchars($nama) ?></span>
</div>

<?php include 'sidebar.php'; ?>

<div class="main-content container-fluid">
<div class="card-custom p-4">

<div class="d-flex justify-content-between mb-3">
<h6 class="mb-0"><i class="bi bi-journal-text"></i> Daftar Materi Saya</h6>
<button class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#modalTambah">
<i class="bi bi-plus-circle"></i> Tambah
</button>
</div>

<div class="table-responsive">
<table class="table table-bordered table-hover align-middle small">
<thead class="table-dark text-center">
<tr>
<th>Judul</th>
<th>Mapel</th>
<th>Kelas</th>
<th>Tipe</th>
<th>Dibaca</th>
<th>Siswa</th>
<th>Terakhir</th>
<th>File</th>
<th width="180">Aksi</th>
</tr>
</thead>
<tbody>
<?php
$q=mysqli_query($conn,"
 SELECT 
  m.*, mp.nama_mapel,
  COUNT(DISTINCT mb.id) total_baca,
  COUNT(DISTINCT mb.siswa_id) siswa_baca,
  MAX(mb.dibaca_pada) terakhir_baca
 FROM materi m
 JOIN materi_kelas mk ON mk.materi_id = m.id
 JOIN kelas k ON k.id = mk.kelas_id
 LEFT JOIN paket p ON p.id = k.paket_id
 LEFT JOIN mapel mp ON mp.id = m.mapel_id
 LEFT JOIN materi_baca mb ON mb.materi_id = m.id
 WHERE m.tutor_id = $tutor_id AND k.tahun_id = $tahun_id
 GROUP BY m.id
 ORDER BY m.created_at DESC
");

if(!mysqli_num_rows($q)){
 echo '<tr><td colspan="9" class="text-center text-muted">Belum ada materi</td></tr>';
}

while($d=mysqli_fetch_assoc($q)){
$file="../materi_upload/".$d['tipe']."/".$d['file'];
?>
<tr>
<td><?= htmlspecialchars($d['judul']) ?></td>
<td><?= htmlspecialchars($d['nama_mapel'] ?? '-') ?></td>
<td>
<?php
$qk=mysqli_query($conn,"
 SELECT k.nama_kelas, p.nama AS nama_paket
 FROM materi_kelas mk 
 JOIN kelas k ON k.id = mk.kelas_id 
 LEFT JOIN paket p ON p.id = k.paket_id
 WHERE mk.materi_id = {$d['id']}
 ORDER BY k.nama_kelas, p.nama
");

while($k=mysqli_fetch_assoc($qk)){
  $label = formatKelasPaket($k['nama_kelas'], $k['nama_paket']);
  echo "<span class='badge bg-secondary me-1'>".htmlspecialchars($label)."</span>";
}
?>
</td>
<td class="text-center">
<span class="badge <?= $d['tipe']=='pdf'?'bg-danger':'bg-success' ?>">
<?= strtoupper($d['tipe']) ?>
</span>
</td>
<td class="text-center"><?= (int)$d['total_baca'] ?></td>
<td class="text-center"><?= (int)$d['siswa_baca'] ?></td>
<td class="text-center">
<?= $d['terakhir_baca']?date('d/m/Y H:i',strtotime($d['terakhir_baca'])):'-' ?>
</td>
<td class="text-center">
<?php if($d['file'] && file_exists($file)){ ?>
<a href="<?= $file ?>" target="_blank" class="btn btn-outline-primary btn-sm">
<i class="bi bi-eye"></i>
</a>
<?php } else echo '-'; ?>
</td>
<td class="text-center">
<button class="btn btn-info btn-sm btn-soal"
 data-id="<?= $d['id'] ?>"
 data-judul="<?= htmlspecialchars($d['judul'],ENT_QUOTES) ?>">
<i class="bi bi-question-circle"></i>
</button>
<button class="btn btn-warning btn-sm btn-edit"
 data-id="<?= $d['id'] ?>"
 data-judul="<?= htmlspecialchars($d['judul'],ENT_QUOTES) ?>"
 data-mapel="<?= $d['mapel_id'] ?>"
 data-tipe="<?= $d['tipe'] ?>">
<i class="bi bi-pencil"></i>
</button>
<button class="btn btn-danger btn-sm btn-hapus" data-id="<?= $d['id'] ?>">
<i class="bi bi-trash"></i>
</button>
</td>
</tr>
<?php } ?>
</tbody>
</table>
</div>

</div>
</div>

<!-- ================= MODAL TAMBAH MATERI ================= -->
<div class="modal fade" id="modalTambah">
<div class="modal-dialog modal-lg modal-dialog-centered">
<form method="post" action="materi_proses.php" enctype="multipart/form-data" class="modal-content">
<input type="hidden" name="aksi" value="tambah">

<div class="modal-header"><h6>Tambah Materi</h6></div>

<div class="modal-body row g-3">
<div class="col-md-6">
<label>Judul</label>
<input type="text" name="judul" class="form-control" required>
</div>

<div class="col-md-6">
<label>Mapel</label>
<select name="mapel_id" class="form-select" required>
<?php
$mp=mysqli_query($conn,"SELECT * FROM mapel ORDER BY nama_mapel");
while($m=mysqli_fetch_assoc($mp)){
 echo "<option value='{$m['id']}'>".htmlspecialchars($m['nama_mapel'])."</option>";
}
?>
</select>
</div>

<div class="col-md-6">
<label>Tipe</label>
<select name="tipe" class="form-select">
<option value="pdf">PDF</option>
<option value="video">Video</option>
</select>
</div>

<div class="col-md-6">
<label>File</label>
<input type="file" name="file" class="form-control" required>
</div>

<div class="col-12">
<label>Kelas</label>
<select name="kelas[]" class="form-select" multiple required>
<?php
$k=mysqli_query($conn,"SELECT k.id, k.nama_kelas, p.nama AS nama_paket
                       FROM kelas k
                       LEFT JOIN paket p ON p.id = k.paket_id
                       WHERE k.tahun_id=$tahun_id
                       ORDER BY k.nama_kelas, p.nama");
while($d=mysqli_fetch_assoc($k)){
 $label = formatKelasPaket($d['nama_kelas'],$d['nama_paket']);
 echo "<option value='{$d['id']}'>".htmlspecialchars($label)."</option>";
}
?>
</select>
</div>
</div>

<div class="modal-footer">
<button class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
<button class="btn btn-primary">Simpan</button>
</div>
</form>
</div>
</div>

<!-- ================= MODAL EDIT MATERI ================= -->
<div class="modal fade" id="modalEdit">
<div class="modal-dialog modal-lg modal-dialog-centered">
<form method="post" action="materi_proses.php" enctype="multipart/form-data" class="modal-content">

<input type="hidden" name="aksi" value="edit">
<input type="hidden" name="id" id="edit_id">

<div class="modal-header bg-warning">
<h6>Edit Materi</h6>
</div>

<div class="modal-body row g-3">

<div class="col-md-6">
<label>Judul</label>
<input type="text" name="judul" id="edit_judul" class="form-control" required>
</div>

<div class="col-md-6">
<label>Mapel</label>
<select name="mapel_id" id="edit_mapel" class="form-select" required>
<?php
$mp=mysqli_query($conn,"SELECT * FROM mapel ORDER BY nama_mapel");
while($m=mysqli_fetch_assoc($mp)){
 echo "<option value='{$m['id']}'>".htmlspecialchars($m['nama_mapel'])."</option>";
}
?>
</select>
</div>

<div class="col-md-6">
<label>Tipe</label>
<select name="tipe" id="edit_tipe" class="form-select">
<option value="pdf">PDF</option>
<option value="video">Video</option>
</select>
</div>

<div class="col-md-6">
<label>Ganti File (opsional)</label>
<input type="file" name="file" class="form-control">
</div>

<div class="col-12">
<label>Kelas</label>
<select name="kelas[]" id="edit_kelas" class="form-select" multiple required>
<?php
$k=mysqli_query($conn,"SELECT k.id, k.nama_kelas, p.nama AS nama_paket
                       FROM kelas k
                       LEFT JOIN paket p ON p.id = k.paket_id
                       WHERE k.tahun_id=$tahun_id
                       ORDER BY k.nama_kelas, p.nama");
while($d=mysqli_fetch_assoc($k)){
 $label = formatKelasPaket($d['nama_kelas'],$d['nama_paket']);
 echo "<option value='{$d['id']}'>".htmlspecialchars($label)."</option>";
}
?>
</select>
</div>

</div>

<div class="modal-footer">
<button class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
<button class="btn btn-warning">Update</button>
</div>

</form>
</div>
</div>


<!-- ================= MODAL SOAL ================= -->
<div class="modal fade" id="modalSoal">
<div class="modal-dialog modal-xl modal-dialog-centered modal-dialog-scrollable">
<div class="modal-content">

<div class="modal-header bg-info text-white">
<h6 class="mb-0"><i class="bi bi-question-circle"></i> Soal Materi : <span id="judul_materi"></span></h6>
<button class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
</div>

<div class="modal-body">
<div class="d-flex justify-content-between mb-2">
<b>Daftar Soal</b>
<button class="btn btn-primary btn-sm" id="btnTambahSoal"><i class="bi bi-plus-circle"></i> Tambah Soal</button>
</div>
<div id="listSoal"></div>
</div>

</div>
</div>
</div>

<!-- ================= MODAL TAMBAH SOAL ================= -->
<div class="modal fade" id="modalTambahSoal">
<div class="modal-dialog modal-lg modal-dialog-centered">
<form method="post" action="soal_proses.php" class="modal-content">
<input type="hidden" name="materi_id" id="soal_materi_id">
<input type="hidden" name="aksi" value="tambah">

<div class="modal-header bg-primary text-white"><h6>Tambah Soal</h6></div>
<div class="modal-body row g-3">
<div class="col-12">
<label>Pertanyaan</label>
<textarea name="pertanyaan" class="form-control" rows="3" required></textarea>
</div>

<div class="col-md-4">
<label>Tipe Soal</label>
<select name="tipe" id="tipeSoal" class="form-select" required>
  <option value="pg">Pilihan Ganda</option>
  <option value="essay">Essay / Isian</option>
  <option value="bs">Benar / Salah</option>
</select>
</div>

<!-- ================= PILIHAN GANDA ================= -->
<div id="box-pg" class="row g-2 mt-2">
<div class="col-md-6"><label>A</label><input type="text" name="a" class="form-control"></div>
<div class="col-md-6"><label>B</label><input type="text" name="b" class="form-control"></div>
<div class="col-md-6"><label>C</label><input type="text" name="c" class="form-control"></div>
<div class="col-md-6"><label>D</label><input type="text" name="d" class="form-control"></div>

<div class="col-md-6">
<label>Jawaban Benar</label>
<select name="jawaban_pg" class="form-select">
<option>A</option><option>B</option><option>C</option><option>D</option>
</select>
</div>
</div>

<!-- ================= BENAR / SALAH ================= -->
<div id="box-bs" class="mt-3" style="display:none">
<label>Jawaban</label>
<select name="jawaban_bs" class="form-select">
<option value="benar">Benar</option>
<option value="salah">Salah</option>
</select>
</div>

<!-- ================= ESSAY ================= -->
<div id="box-essay" class="mt-3" style="display:none">
<label>Kunci Jawaban (opsional)</label>
<textarea name="jawaban_essay" class="form-control" rows="3"></textarea>
</div>
<div class="modal-footer"><button class="btn btn-secondary" data-bs-dismiss="modal">Batal</button><button class="btn btn-primary">Simpan</button></div>
</form>
</div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
<script>
let currentMateri = 0;

/* ================= EVENT KLIK ================= */
document.addEventListener('click',function(e){

/* ================= BUKA MODAL SOAL ================= */
const soal = e.target.closest('.btn-soal');
if(soal){
  currentMateri = soal.dataset.id;
  document.getElementById('judul_materi').innerText = soal.dataset.judul;

  fetch('soal_list_ajax.php?materi_id='+currentMateri)
    .then(r=>r.text())
    .then(html=>document.getElementById('listSoal').innerHTML = html);

  new bootstrap.Modal(document.getElementById('modalSoal')).show();
}

/* ================= TAMBAH SOAL ================= */
const tambahSoal = e.target.closest('#btnTambahSoal');
if(tambahSoal){
  document.getElementById('soal_materi_id').value = currentMateri;

  /* reset form */
  const form = document.querySelector('#modalTambahSoal form');
  form.reset();

  new bootstrap.Modal(document.getElementById('modalTambahSoal')).show();
}

/* ================= EDIT MATERI ================= */
const editMateri = e.target.closest('.btn-edit');
if(editMateri){
  fetch('materi_get_data.php?id='+editMateri.dataset.id)
   .then(r=>r.json())
   .then(d=>{
    edit_id.value    = d.id;
    edit_judul.value= d.judul;
    edit_mapel.value= d.mapel_id;
    edit_tipe.value = d.tipe;

    [...edit_kelas.options].forEach(o=>o.selected=false);
    d.kelas.forEach(id=>{
      const o = edit_kelas.querySelector('option[value="'+id+'"]');
      if(o) o.selected = true;
    });

    new bootstrap.Modal(document.getElementById('modalEdit')).show();
   });
}

/* ================= HAPUS MATERI ================= */
const hapus = e.target.closest('.btn-hapus');
if(hapus){
  if(confirm('Yakin hapus materi ini? Semua soal ikut terhapus!')){
    window.location = 'materi_proses.php?aksi=hapus&id='+hapus.dataset.id;
  }
}

});
const tipeSoal = document.getElementById('tipeSoal');

function updateTipe(){
  const tipe = tipeSoal.value;

  document.getElementById('box-pg').style.display    = (tipe=='pg')?'flex':'none';
  document.getElementById('box-bs').style.display    = (tipe=='bs')?'block':'none';
  document.getElementById('box-essay').style.display = (tipe=='essay')?'block':'none';
}

tipeSoal.addEventListener('change', updateTipe);
updateTipe();

</script>


</body>
</html>
