<?php
session_start();
require '../config/database.php';

if (
    empty($_SESSION['login']) ||
    ($_SESSION['user']['role'] ?? '') !== 'tutor'
) {
    header("Location: ../auth/login.php");
    exit;
}

$tutor_id = $_SESSION['user']['id'];

$hariList = ['Senin','Selasa','Rabu','Kamis','Jumat','Sabtu'];
$data = [];

$q = mysqli_query($conn,"
 SELECT 
   j.*,
   CONCAT(
     k.nama_kelas,
     IFNULL(CONCAT(UPPER(p.nama)), '')
   ) AS label_kelas,
   m.nama_mapel
 FROM jadwal j
 JOIN kelas k ON j.kelas_id = k.id
 LEFT JOIN paket p ON p.id = k.paket_id
 JOIN mapel m ON j.mapel_id = m.id
 WHERE j.tutor_id = '$tutor_id'
 ORDER BY FIELD(j.hari,'Senin','Selasa','Rabu','Kamis','Jumat','Sabtu'),
          j.jam_mulai
");


while ($r = mysqli_fetch_assoc($q)) {
    $data[$r['hari']][] = $r;
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Jadwal Mengajar</title>
<meta name="viewport" content="width=device-width, initial-scale=1">

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">

<style>
body{background:#f4f6f9;font-size:14px}

/* ===== KONTEN ===== */
.main-content{
    margin-left:260px;
    padding:20px;
}
@media(max-width:991px){
    .main-content{
        margin-left:0;
        padding:15px;
    }
}

/* ===== TOPBAR HP ===== */
.topbar{
    display:none;
}
@media(max-width:991px){
    .topbar{
        display:flex;
        align-items:center;
        gap:10px;
        background:#0d6efd;
        color:#fff;
        padding:10px 14px;
        position:sticky;
        top:0;
        z-index:1020;
    }
}

/* ===== JADWAL ===== */
.card{
    border:none;
    border-radius:16px;
}
.jadwal-item{
    background:#f8f9fa;
    border-left:5px solid #0d6efd;
    border-radius:12px;
    padding:10px;
    margin-bottom:8px;
}
.jadwal-item .mapel{
    font-weight:600;
}
.jadwal-item .jam{
    color:#0d6efd;
    font-weight:600;
    font-size:13px;
}
/* ===== FOOTER MOBILE MENU ===== */
.footer-mobile{
 display:none;
}

@media(max-width:991px){
 .footer-mobile{
  display:flex;
  position:fixed;
  bottom:0;
  left:0;
  right:0;
  background:#fff;
  border-top:1px solid #ddd;
  z-index:999;
 }

 .footer-mobile a{
  flex:1;
  text-align:center;
  padding:8px 4px;
  font-size:11px;
  color:#666;
  text-decoration:none;
 }

 .footer-mobile a i{
  font-size:18px;
  display:block;
 }

 .footer-mobile a.active{
  color:#0d6efd;
  font-weight:600;
 }

 .footer-mobile a.active i{
  color:#0d6efd;
 }

 /* kasih ruang supaya konten ga ketutup footer */
 body{padding-bottom:65px}
}

</style>
</head>
<!-- FOOTER MOBILE -->
<div class="footer-mobile d-lg-none">

 <a href="profil.php" class="active">
  <i class="bi bi-person-circle"></i>
  Profil
 </a>

 <a href="absen_list_cetak.php">
  <i class="bi bi-clipboard-check"></i>
  Absen
 </a>

 <a href="materi.php">
  <i class="bi bi-journal-text"></i>
  Materi
 </a>

 <a href="elearning.php">
  <i class="bi bi-laptop"></i>
  E-Learning
 </a>

 <a href="absen_dan_jawaban.php">
  <i class="bi bi-ui-checks-grid"></i>
  Jawaban
 </a>

</div>

<body>

<!-- ===== TOPBAR HP ===== -->
<div class="topbar d-lg-none">
    <button class="btn btn-light btn-sm"
        data-bs-toggle="offcanvas"
        data-bs-target="#sidebarTutor">
        <i class="bi bi-list"></i>
    </button>
    <strong>Jadwal Mengajar</strong>
</div>

<?php include 'sidebar.php'; ?>

<!-- ===== KONTEN ===== -->
<div class="main-content">

<h5 class="fw-bold mb-3 d-none d-lg-block">
<i class="bi bi-calendar-week"></i> Jadwal Mengajar Mingguan
</h5>

<div class="row g-3">
<?php foreach ($hariList as $hari): ?>
<div class="col-12 col-md-6 col-lg-4">
    <div class="card p-3 h-100 shadow-sm">
        <h6 class="fw-bold mb-2"><?= $hari ?></h6>

        <?php if (empty($data[$hari])): ?>
            <small class="text-muted">Tidak ada jadwal</small>
        <?php else: ?>
            <?php foreach ($data[$hari] as $j): ?>
                <div class="jadwal-item">
                    <div class="mapel"><?= htmlspecialchars($j['nama_mapel']) ?></div>
                    <small class="text-muted"><?= htmlspecialchars($j['label_kelas']) ?></small><br>

                    <span class="jam">
                        <?= substr($j['jam_mulai'],0,5) ?> -
                        <?= substr($j['jam_selesai'],0,5) ?>
                    </span>
                </div>
            <?php endforeach; ?>
        <?php endif; ?>

    </div>
</div>
<?php endforeach; ?>
</div>

</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
