<?php
session_start();
require '../config/database.php';

/* ================= PROTEKSI ================= */
if (
    empty($_SESSION['login']) ||
    ($_SESSION['user']['role'] ?? '') !== 'tutor'
) {
    header("Location: ../auth/login.php");
    exit;
}

$tutor_id = $_SESSION['user']['id'];

/* ================= HELPER ================= */
function formatKelasPaket($kelas, $paket){
    if(!$kelas) return '-';
    if($paket) return "$kelas-$paket";
    return $kelas;
}

function badgeStatus($s){
    return match(strtolower($s)){
        'hadir' => '<span class="badge bg-success">Hadir</span>',
        'izin'  => '<span class="badge bg-warning text-dark">Izin</span>',
        'alfa'  => '<span class="badge bg-danger">Alfa</span>',
        default => '<span class="badge bg-secondary">'.htmlspecialchars($s).'</span>',
    };
}


$BASE_FOTO = "/pkbm-test/edu_digital/uploads/absen/";
$DIR_FOTO  = rtrim($_SERVER['DOCUMENT_ROOT'], '/').$BASE_FOTO;


/* ================= FILTER ================= */
$kelas_id = $_GET['kelas_id'] ?? '';
$mapel_id = $_GET['mapel_id'] ?? '';

$where = "WHERE km.tutor_id='$tutor_id'";
if($kelas_id) $where .= " AND k.id='$kelas_id'";
if($mapel_id) $where .= " AND mp.id='$mapel_id'";

/* ================= FILTER TANGGAL ================= */
$mode = $_GET['mode'] ?? 'harian'; // harian | mingguan | bulanan | range
$tgl1 = $_GET['tgl1'] ?? date('Y-m-d');
$tgl2 = $_GET['tgl2'] ?? date('Y-m-d');

/* tentukan range */
if ($mode === 'harian') {
    $awal = $akhir = $tgl1;
}
elseif ($mode === 'mingguan') {
    $awal  = date('Y-m-d', strtotime('monday this week', strtotime($tgl1)));
    $akhir = date('Y-m-d', strtotime('sunday this week', strtotime($tgl1)));
}
elseif ($mode === 'bulanan') {
    $awal  = date('Y-m-01', strtotime($tgl1));
    $akhir = date('Y-m-t', strtotime($tgl1));
}
else { // range
    $awal  = $tgl1;
    $akhir = $tgl2;
}

/* ================= DATA DROPDOWN ================= */
$qKelas = mysqli_query($conn,"
    SELECT k.id, CONCAT(k.nama_kelas, '-', p.nama) AS label
    FROM kelas k
    LEFT JOIN paket p ON p.id = k.paket_id
    ORDER BY k.nama_kelas, p.nama
");

$qMapel = mysqli_query($conn,"
    SELECT DISTINCT mp.id, mp.nama_mapel
    FROM mapel mp
    JOIN kelas_mengajar km ON km.mapel_id = mp.id
    WHERE km.tutor_id='$tutor_id'
    ORDER BY mp.nama_mapel
");

/* ================= DATA ABSEN ================= */
$q = mysqli_query($conn,"
 SELECT
  s.nama AS nama_siswa,
  k.nama_kelas,
  p.nama AS nama_paket,
  mp.nama_mapel,
  pr.tanggal,
  pr.jam,
  pr.status,
  pr.foto,
  pr.latitude,
  pr.longitude
 FROM presensi pr
 JOIN siswa s ON s.id = pr.siswa_id
 JOIN kelas k ON k.id = s.kelas_id
 LEFT JOIN paket p ON p.id = k.paket_id
 JOIN mapel mp ON mp.id = pr.mapel_id
 JOIN kelas_mengajar km 
   ON km.kelas_id = k.id 
  AND km.mapel_id = mp.id
 $where
 AND pr.tanggal BETWEEN '$awal' AND '$akhir'
 ORDER BY pr.tanggal DESC, pr.jam DESC
");


?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Daftar Absensi Siswa</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">

<style>

/* ================= GLOBAL ================= */
body{
  background:#f4f6f9;
  font-size:14px;
}

.main-content{
  margin-left:260px;
  padding:20px;
}

@media(max-width:991px){
  .main-content{
    margin-left:0;
  }
}

.card{
  border-radius:16px;
}

.footer{
  background:#fff;
  border-top:1px solid #ddd;
  padding:12px;
  font-size:12px;
  color:#666;
}

/* ================= PRINT ================= */
@media print{
  .btn,
  .footer,
  .offcanvas,
  .offcanvas-backdrop,
  .d-lg-none{
    display:none!important;
  }

  body{
    background:white;
    font-size:12px;
  }
}

/* ================= FOTO PRESENSI (DESKTOP DEFAULT) ================= */
.foto-presensi{
  width:35px !important;
  height:35px !important;
  max-width:35px !important;
  max-height:35px !important;
  object-fit:cover;
  border-radius:50%;
  border:2px solid #28a745;
  cursor:pointer;
  transition:.2s ease;
  background:#fff;
  display:block;
  margin:auto;
}

.foto-presensi:hover{
  transform:scale(1.1);
  box-shadow:0 0 6px rgba(0,0,0,.25);
}

/* supaya bootstrap tidak membesarkan gambar */
table td img{
  width:35px !important;
  height:35px !important;
}

/* ================= FOTO ZOOM MODAL ================= */
#fotoZoom{
  max-height:75vh;
  border-radius:14px;
  box-shadow:0 10px 30px rgba(0,0,0,.45);
}

/* ================= FOOTER MOBILE MENU ================= */
.footer-mobile{
  display:none;
}

@media(max-width:991px){

  body{
    padding-bottom:65px;
  }

  .footer-mobile{
    display:flex;
    position:fixed;
    bottom:0;
    left:0;
    right:0;
    background:#fff;
    border-top:1px solid #ddd;
    z-index:999;
  }

  .footer-mobile a{
    flex:1;
    text-align:center;
    padding:8px 4px;
    font-size:11px;
    color:#666;
    text-decoration:none;
  }

  .footer-mobile a i{
    font-size:18px;
    display:block;
  }

  .footer-mobile a.active{
    color:#0d6efd;
    font-weight:600;
  }

  .footer-mobile a.active i{
    color:#0d6efd;
  }

  /* ukuran foto sedikit lebih besar di mobile */
  .foto-presensi{
    width:50px !important;
    height:50px !important;
    max-width:50px !important;
    max-height:50px !important;
  }

}

</style>

</head>
<!-- FOOTER MOBILE -->
<div class="footer-mobile d-lg-none">

 <a href="profil.php" class="active">
  <i class="bi bi-person-circle"></i>
  Profil
 </a>

 <a href="absen_list_cetak.php">
  <i class="bi bi-clipboard-check"></i>
  Absen
 </a>

 <a href="materi.php">
  <i class="bi bi-journal-text"></i>
  Materi
 </a>

 <a href="elearning.php">
  <i class="bi bi-laptop"></i>
  E-Learning
 </a>

 <a href="absen_dan_jawaban.php">
  <i class="bi bi-ui-checks-grid"></i>
  Jawaban
 </a>

</div>

<body>

<!-- TOPBAR MOBILE -->
<div class="d-lg-none bg-primary text-white p-2 d-flex align-items-center gap-2">
 <button class="btn btn-light btn-sm" data-bs-toggle="offcanvas" data-bs-target="#sidebarTutor">
  <i class="bi bi-list"></i>
 </button>
 <b>Daftar Absensi</b>
</div>

<?php include 'sidebar.php'; ?>

<div class="main-content">

<!-- ================= FILTER ================= -->
<div class="card mb-3">
 <div class="card-body">
  <form class="row g-2">

 <input type="hidden" name="kelas_id" value="<?= $kelas_id ?>">
 <input type="hidden" name="mapel_id" value="<?= $mapel_id ?>">

 <div class="col-md-3">
  <label class="small">Kelas</label>
  <select name="kelas_id" class="form-select form-select-sm">
   <option value="">Semua Kelas</option>
   <?php while($k=mysqli_fetch_assoc($qKelas)){ ?>
    <option value="<?= $k['id'] ?>" <?= $kelas_id==$k['id']?'selected':'' ?>>
     <?= $k['label'] ?>
    </option>
   <?php } ?>
  </select>
 </div>

 <div class="col-md-3">
  <label class="small">Mapel</label>
  <select name="mapel_id" class="form-select form-select-sm">
   <option value="">Semua Mapel</option>
   <?php while($m=mysqli_fetch_assoc($qMapel)){ ?>
    <option value="<?= $m['id'] ?>" <?= $mapel_id==$m['id']?'selected':'' ?>>
     <?= $m['nama_mapel'] ?>
    </option>
   <?php } ?>
  </select>
 </div>

 <div class="col-md-2">
  <label class="small">Mode</label>
  <select name="mode" class="form-select form-select-sm"
          onchange="this.form.submit()">
   <option value="harian" <?= $mode=='harian'?'selected':'' ?>>Harian</option>
   <option value="mingguan" <?= $mode=='mingguan'?'selected':'' ?>>Mingguan</option>
   <option value="bulanan" <?= $mode=='bulanan'?'selected':'' ?>>Bulanan</option>
   <option value="range" <?= $mode=='range'?'selected':'' ?>>Rentang</option>
  </select>
 </div>

 <div class="col-md-2">
  <label class="small">Tanggal</label>
  <input type="date" name="tgl1" value="<?= $tgl1 ?>" class="form-control form-control-sm">
 </div>

 <?php if($mode=='range'){ ?>
 <div class="col-md-2">
  <label class="small">Sampai</label>
  <input type="date" name="tgl2" value="<?= $tgl2 ?>" class="form-control form-control-sm">
 </div>
 <?php } ?>

 <div class="col-md-2 d-flex align-items-end">
  <button class="btn btn-primary btn-sm w-100">
   <i class="bi bi-funnel"></i> Filter
  </button>
 </div>

 <div class="col-md-2 d-flex align-items-end">
  <a href="absen_cetak.php?kelas_id=<?= $kelas_id ?>&mapel_id=<?= $mapel_id ?>
     &mode=<?= $mode ?>&tgl1=<?= $tgl1 ?>&tgl2=<?= $tgl2 ?>"
     target="_blank"
     class="btn btn-success btn-sm w-100">
   <i class="bi bi-printer"></i> Cetak
  </a>
 </div>
 <div class="col-md-2 d-flex align-items-end">
  <a href="absen_cetak_pdf.php?kelas_id=1&mapel_id=1&tgl_awal=2026-01-23&tgl_akhir=2026-01-26"
   target="_blank"
   class="btn btn-danger">
   <i class="bi bi-file-earmark-pdf"></i> PDF
</a>

 </div>

</form>

 </div>
</div>

<!-- ================= TABEL ================= -->
<div class="card">
 <div class="card-header bg-primary text-white">
  <i class="bi bi-clipboard-check"></i> Daftar Absensi Siswa
 </div>

 <div class="card-body table-responsive">
  <table class="table table-bordered table-striped">
   <thead class="table-light text-center">
    <tr>
     <th>No</th>
     <th>Nama</th>
     <th>Kelas</th>
     <th>Mapel</th>
     <th>Tanggal</th>
     <th>Jam</th>
     <th>Status</th>
     <th>Foto</th>
     <th>Lokasi</th>


    </tr>
   </thead>
   <tbody>
   <?php if(mysqli_num_rows($q)==0){ ?>
    <tr><td colspan="7" class="text-center text-muted">Tidak ada data</td></tr>
   <?php } else {
    $no=1;
    while($r=mysqli_fetch_assoc($q)){ ?>
    <tr>
     <td class="text-center"><?= $no++ ?></td>
     <td><?= htmlspecialchars($r['nama_siswa']) ?></td>
     <td class="text-center"><?= formatKelasPaket($r['nama_kelas'],$r['nama_paket']) ?></td>
     <td><?= $r['nama_mapel'] ?></td>
     <td class="text-center"><?= date('d-m-Y',strtotime($r['tanggal'])) ?></td>
     <td class="text-center"><?= substr($r['jam'],0,5) ?></td>
     <td class="text-center"><?= badgeStatus($r['status']) ?></td>

<?php
$src = '';

if (!empty($r['foto'])) {
    $namaFoto = basename($r['foto']); // keamanan
    $fullpath = $DIR_FOTO . $namaFoto;

    if (file_exists($fullpath)) {
        $src = $BASE_FOTO . $namaFoto;
    }
}


?>

<td class="text-center align-middle">
<?php if($src){ 
  $border = match(strtolower($r['status'])){
    'hadir' => '#28a745',
    'izin'  => '#ffc107',
    'alfa'  => '#dc3545',
    default => '#6c757d'
  };
?>
  <img src="<?= $src ?>" 
       class="foto-presensi"
       style="border-color:<?= $border ?>"
       onclick="zoomFoto(this.src)">
<?php } else { ?>
  <span class="text-muted small">-</span>
<?php } ?>
</td>


<td class="text-center">
<?php if(!empty($r['latitude']) && !empty($r['longitude'])){ ?>
  <a href="https://www.google.com/maps?q=<?= $r['latitude'] ?>,<?= $r['longitude'] ?>"
     target="_blank"
     class="btn btn-sm btn-outline-primary">
     <i class="bi bi-geo-alt"></i>
  </a>
<?php } else { ?>
  <span class="text-muted small">-</span>
<?php } ?>
</td>

    </tr>
   <?php }} ?>
   </tbody>
  </table>
 </div>
</div>

</div>



<?php if(isset($_GET['cetak'])) echo "<script>window.print()</script>"; ?>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
<div class="modal fade" id="modalFoto" tabindex="-1">
 <div class="modal-dialog modal-dialog-centered modal-lg">
  <div class="modal-content">
   <div class="modal-body text-center">
    <img id="fotoZoom" src="" class="img-fluid rounded">
   </div>
  </div>
 </div>
</div>
<script>
function zoomFoto(src){
  document.getElementById('fotoZoom').src = src;
  new bootstrap.Modal(document.getElementById('modalFoto')).show();
}
</script>

</html>
