<?php
session_start();
if(empty($_SESSION['login_siswa'])){
    header("Location: ../../auth/login_siswa.php");
    exit;
}

$nama = $_SESSION['siswa']['nama'];
$room = $_GET['room'] ?? 'kelas_online';
?>

<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<title>Kelas Online</title>
<script src="https://meet.jit.si/external_api.js"></script>
<style>
body{
    margin:0;
    background:#000;
}
#meet{
    height:100vh;
    width:100%;
}
.top-bar{
    position:absolute;
    top:10px;
    left:20px;
    z-index:999;
    color:white;
    font-weight:bold;
}
</style>
</head>
<body>

<div class="top-bar">
    📚 Siswa: <?= $nama ?>
</div>

<div id="meet"></div>

<script>
const domain = "meet.jit.si";
const options = {
    roomName: "PKBM_<?= $room ?>",
    width: "100%",
    height: "100%",
    parentNode: document.querySelector('#meet'),
    userInfo: {
        displayName: "Siswa - <?= $nama ?>"
    }
};
const api = new JitsiMeetExternalAPI(domain, options);
</script>

</body>
</html>
