<?php
session_start();
require '../config/database.php';

/* ================= PROTEKSI LOGIN ================= */
if (
    empty($_SESSION['login_siswa']) ||
    empty($_SESSION['siswa']['id'])
) {
    header("Location: login_siswa.php");
    exit;
}

$siswa_id = $_SESSION['siswa']['id'];

$id = intval($_GET['id'] ?? 0);
if ($id == 0) {
    die("Materi tidak ditemukan");
}

/* ================= CEK DATA MATERI + MAPEL ================= */
$qm = mysqli_query($conn,"
 SELECT m.*, mp.id AS mapel_id, mp.nama_mapel
 FROM materi m
 JOIN mapel mp ON mp.id = m.mapel_id
 WHERE m.id = '$id'
 LIMIT 1
");
$materi = mysqli_fetch_assoc($qm);

if(!$materi){
    die("Materi tidak ditemukan di database");
}

$mapel_id = $materi['mapel_id'];

/* ================= CEK ABSEN (WAJIB) ================= */
$cek_absen = mysqli_query($conn,"
 SELECT id FROM presensi
 WHERE siswa_id = '$siswa_id'
   AND mapel_id = '$mapel_id'
   AND tanggal = CURDATE()
   AND status = 'hadir'
 LIMIT 1
");

if(mysqli_num_rows($cek_absen) == 0){
    echo "
    <script>
      alert('Anda harus melakukan absen terlebih dahulu sebelum membuka materi ini!');
      window.location.href = 'materi.php';
    </script>
    ";
    exit;
}

/* ================= CEK SUDAH BACA ATAU BELUM ================= */
$cek = mysqli_query($conn,"
 SELECT * FROM materi_baca
 WHERE siswa_id='$siswa_id' AND materi_id='$id'
 LIMIT 1
");

$sudah_baca = false;

if(mysqli_num_rows($cek)>0){
    $sudah_baca = true;
}

/* ================= JIKA BELUM PERNAH BACA → SIMPAN ================= */
if(!$sudah_baca){
    mysqli_query($conn,"
 INSERT INTO materi_baca (siswa_id, materi_id)
 VALUES ('$siswa_id','$id')
");

}

/* ================= AMBIL DATA LENGKAP MATERI ================= */
$q = mysqli_query($conn,"
 SELECT 
  m.*,
  mp.nama_mapel,
  t.nama AS tutor
 FROM materi m
 LEFT JOIN mapel mp ON m.mapel_id = mp.id
 LEFT JOIN tutor t ON m.tutor_id = t.id
 WHERE m.id = '$id'
 LIMIT 1
");

$materi = mysqli_fetch_assoc($q);

/* ================= PATH FILE SESUAI FOLDER ================= */
$file = $materi['file'];
$tipe = $materi['tipe'];

$basePath = $_SERVER['DOCUMENT_ROOT']."/pkbm_qurani/materi_upload/";
$baseView = "/pkbm_qurani/materi_upload/";

if ($tipe == 'pdf') {
    $fullPath = $basePath . "pdf/" . $file;
    $viewPath = $baseView . "pdf/" . $file;
} elseif ($tipe == 'video') {
    $fullPath = $basePath . "video/" . $file;
    $viewPath = $baseView . "video/" . $file;
} elseif ($tipe == 'audio') {
    $fullPath = $basePath . "audio/" . $file;
    $viewPath = $baseView . "audio/" . $file;
} else {
    $fullPath = $basePath . $file;
    $viewPath = $baseView . $file;
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title><?= htmlspecialchars($materi['judul']) ?> - Materi</title>
<meta name="viewport" content="width=device-width, initial-scale=1">

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">

<style>
body{
 background:#f4f6f9;
 min-height:100vh;
 display:flex;
 flex-direction:column;
}
.card-materi{
 border-radius:16px;
}
.header-info span{
 display:inline-block;
 margin-right:15px;
}
.viewer{
 background:#fff;
 border-radius:15px;
 padding:12px;
 min-height:300px;
}
.footer-space{margin-top:auto}
</style>
</head>

<body>

<!-- NAVBAR -->
<nav class="navbar navbar-dark bg-primary shadow-sm">
 <div class="container-fluid">
  <a href="materi.php" class="navbar-brand">
   <i class="bi bi-arrow-left-circle"></i> Kembali
  </a>
  <span class="fw-bold">E-Learning PKBM</span>
 </div>
</nav>

<div class="container py-4">

<!-- INFO MATERI -->
<div class="card card-materi shadow-sm mb-4">
 <div class="card-body">

  <h4 class="fw-bold mb-2">
   <i class="bi bi-book-half text-primary"></i> 
   <?= htmlspecialchars($materi['judul']) ?>
  </h4>

  <div class="header-info small text-muted mb-3">
   <span><i class="bi bi-journal-text"></i> <?= $materi['nama_mapel'] ?></span>
   <span><i class="bi bi-person-circle"></i> <?= $materi['tutor'] ?></span>
   <span><i class="bi bi-clock"></i> <?= date('d M Y H:i',strtotime($materi['created_at'])) ?></span>
   <span class="badge bg-info text-dark"><?= strtoupper($materi['tipe']) ?></span>

   <?php if($sudah_baca): ?>
   <span class="badge bg-success">
     <i class="bi bi-check-circle"></i> Sudah Dibaca
   </span>
   <?php else: ?>
   <span class="badge bg-warning text-dark">
     <i class="bi bi-eye"></i> Pertama Kali Dibuka
   </span>
   <?php endif; ?>
  </div>

  <!-- VIEWER -->
  <div class="viewer shadow-sm">

<?php
if ($file && file_exists($fullPath)) {

  $ext = strtolower(pathinfo($file, PATHINFO_EXTENSION));

  if ($ext == 'pdf') {
    echo "<iframe src='$viewPath' style='width:100%;height:80vh;border-radius:10px;border:1px solid #ddd'></iframe>";
  }
  elseif (in_array($ext,['mp4','webm','ogg'])) {
    echo "<video controls class='w-100 rounded shadow-sm' style='max-height:80vh'>
            <source src='$viewPath'>
          </video>";
  }
  elseif (in_array($ext,['mp3','wav'])) {
    echo "<audio controls class='w-100 mt-3'><source src='$viewPath'></audio>";
  }
  else {
    echo "<div class='alert alert-warning text-center'>Format file tidak dikenali.</div>";
  }

} else {
  echo "<div class='alert alert-danger text-center'>
          <b>File materi tidak ditemukan</b><br>$fullPath
        </div>";
}
?>

  </div>

 </div>
</div>

</div>

<!-- FOOTER -->
<div class="footer-space">
<?php include 'footer.php'; ?>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
