<?php
session_start();
require '../config/database.php';

if (
 empty($_SESSION['login_siswa']) ||
 empty($_SESSION['siswa']['id'])
) {
 header("Location: login_siswa.php");
 exit;
}

$siswa_id = $_SESSION['siswa']['id'];
$kelas_id = $_SESSION['siswa']['kelas_id'];

/* ================= MATERI + STATUS BACA ================= */
$q = mysqli_query($conn,"
 SELECT 
  m.id,
  m.judul,
  mp.nama_mapel,
  mb.id AS sudah_baca
 FROM materi m
 JOIN mapel mp ON mp.id = m.mapel_id
 JOIN materi_kelas mk ON mk.materi_id = m.id
 LEFT JOIN materi_baca mb 
   ON mb.materi_id = m.id 
  AND mb.siswa_id = '$siswa_id'
 WHERE mk.kelas_id = '$kelas_id'
 ORDER BY m.created_at DESC
");
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>E-Learning Siswa</title>
<meta name="viewport" content="width=device-width, initial-scale=1">

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">

<style>
body{
 background:#eef2f7;
 min-height:100vh;
 display:flex;
 flex-direction:column;
}
.card-elearn{
 border-radius:18px;
 transition:.3s;
}
.card-elearn:hover{
 transform:translateY(-5px);
 box-shadow:0 12px 30px rgba(0,0,0,.12);
}
/* ===== FOOTER NAV ===== */
.footer-nav{
 position:fixed;
 bottom:0;
 left:0;
 right:0;
 background:linear-gradient(135deg,#f7e38c,#b9e4a6,#a3d9f5);
 border-top:1px solid #ddd;
 display:flex;
 justify-content:space-around;
 padding:8px 0;
 z-index:999;
}
.footer-nav a{
 text-decoration:none;
 color:#666;
 font-size:12px;
 text-align:center;
}
.footer-nav i{
 font-size:20px;
 display:block;
}
.footer-space{height:70px}
</style>
</head>
<body>

<!-- ================= NAVBAR ================= -->
<nav class="navbar navbar-dark bg-primary shadow-sm">
 <div class="container-fluid">
  
  <span class="fw-bold">
   <i class="bi bi-laptop"></i> E-Learning
  </span>
 </div>
</nav>

<div class="container py-4">

<h5 class="fw-bold mb-4">
 <i class="bi bi-journal-bookmark"></i> Daftar Materi & Soal
</h5>

<div class="row g-4">

<?php if(mysqli_num_rows($q)==0): ?>
<div class="col-12">
 <div class="alert alert-info text-center">
  <i class="bi bi-info-circle"></i><br>
  Belum ada materi untuk kelas Anda.
 </div>
</div>
<?php endif; ?>

<?php while($m = mysqli_fetch_assoc($q)): ?>

<?php
$sudah = !empty($m['sudah_baca']);
?>

<div class="col-12 col-md-6 col-lg-4">
 <div class="card card-elearn shadow-sm p-3 h-100">

  <h6 class="fw-bold mb-1"><?= htmlspecialchars($m['judul']) ?></h6>
  <small class="text-muted d-block mb-2"><?= $m['nama_mapel'] ?></small>

  <div class="mb-3">
   <?php if($sudah): ?>
    <span class="badge bg-success">
     <i class="bi bi-check-circle"></i> Sudah Dibaca
    </span>
   <?php else: ?>
    <span class="badge bg-warning text-dark">
     <i class="bi bi-eye"></i> Belum Dibaca
    </span>
   <?php endif; ?>
  </div>

  <?php if($sudah): ?>

   <!-- SOAL BISA DIBUKA -->
   <a href="soal.php?materi_id=<?= $m['id'] ?>" 
      class="btn btn-primary w-100">
    <i class="bi bi-pencil-square"></i> Kerjakan Soal
   </a>

  <?php else: ?>

   <!-- DIKUNCI -->
   <a href="materi_view.php?id=<?= $m['id'] ?>" 
      class="btn btn-warning w-100 mb-2">
    <i class="bi bi-book-half"></i> Baca Materi
   </a>

   <button class="btn btn-secondary w-100" disabled>
    <i class="bi bi-lock"></i> Soal Terkunci
   </button>

  <?php endif; ?>

 </div>
</div>

<?php endwhile; ?>

</div>
</div>

<!-- ================= FOOTER ================= -->
<div class="footer-nav">
 <a href="dashboard.php"><i class="bi bi-house"></i>Home</a>
 <a href="absen_list.php"><i class="bi bi-camera"></i>Absen</a>
 <a href="materi.php"><i class="bi bi-book"></i>Materi</a>
 <a href="elearning.php"><i class="bi bi-laptop"></i>E-Learning</a>
 <a href="#"><i class="bi bi-journal-check"></i>Ujian</a>
</div>

<div class="footer-space"></div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>

