<?php
// koneksi database
$conn = mysqli_connect("localhost","root","","pkbm_taruna_qurani");
if (!$conn) die("Koneksi gagal: " . mysqli_connect_error());

// Ambil data PKBM
$qPkbm = mysqli_query($conn, "SELECT nama_sekolah, logo FROM pkbm LIMIT 1");
$dataPkbm = mysqli_fetch_assoc($qPkbm);

$logoSekolah = (!empty($dataPkbm['logo']) && file_exists(__DIR__ . '/../assets/img/' . $dataPkbm['logo']))
    ? '../assets/img/' . $dataPkbm['logo']
    : '../assets/img/logo.png';

$namaSekolah = !empty($dataPkbm['nama_sekolah']) ? $dataPkbm['nama_sekolah'] : 'PKBM';
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Login <?= htmlspecialchars($namaSekolah) ?></title>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css">
<style>
body{
  margin:0;
  background:linear-gradient(135deg,#f7e38c,#b9e4a6,#a3d9f5);
  display:flex;
  justify-content:center;
  align-items:center;
  height:100vh
}
.card-login {
    width: 320px;
    padding: 2rem 1.5rem;
    border-radius: 12px;
    box-shadow: 0 6px 18px rgba(0,0,0,.15);
    background: #fff;
}
.logo-login {
    display: block;
    margin: 0 auto 15px auto;
    max-width: 120px;
    height: auto;
}
h4 {
    text-align: center;
    margin-bottom: 1rem;
}
.form-control:focus {
    box-shadow: 0 0 0 0.2rem rgba(13,110,253,.25);
    border-color: #0d6efd;
}
button:hover {
    opacity: 0.95;
}
.footer{
  font-size:12px;
  color:#adb5bd;
}
</style>
</head>
<body class="d-flex justify-content-center align-items-center vh-100">

<form action="login_proses.php" method="POST" class="card-login">

    <!-- Logo -->
    <img src="<?= htmlspecialchars($logoSekolah) ?>" class="logo-login" alt="<?= htmlspecialchars($namaSekolah) ?>">

    <!-- Judul -->
    <h4 class="text-center mb-4 fw-bold text-primary">
    DARING EDUCATION
  </h4>

    <!-- Input -->
    <input type="text" name="username" class="form-control mb-2" placeholder="Username" required>
    <input type="password" name="password" class="form-control mb-3" placeholder="Password" required>

    <!-- Tombol -->
    <button type="submit" class="btn btn-primary w-100 mb-2">Login</button>
    <a href="/pkbm-test/index.html" class="btn btn-secondary w-100">Batal</a>
<div class="text-center footer mt-3">
    Dikembangkan oleh <b>Bang Zae</b>
  </div>
</form>

</body>
</html>
