<?php
session_start();
require "../config/database.php";

if (empty($_SESSION['login']) || $_SESSION['user']['role'] != 'admin') {
    exit("No access");
}

$id  = (int)($_GET['id'] ?? 0);
$act = $_GET['act'] ?? '';

$q = mysqli_query($conn,"
    SELECT i.*, t.nama, t.no_hp
    FROM izin_cuti i
    JOIN tutor t ON i.tutor_id=t.id
    WHERE i.id='$id'
");
$r = mysqli_fetch_assoc($q);

if (!$r) exit("Data tidak ditemukan");

/* ===== NORMALISASI NOMOR WA ===== */
$no_hp = preg_replace('/\D/', '', $r['no_hp']);
if (substr($no_hp,0,1)=='0') {
    $no_hp = '62'.substr($no_hp,1);
}

/* ===== APPROVE ===== */
if ($act == 'approve') {

    mysqli_query($conn,"
        UPDATE izin_cuti
        SET status_approval='approved',
            approved_at=NOW(),
            approved_by=".$_SESSION['user']['id']."
        WHERE id='$id'
    ");

    $pesan = rawurlencode(
        "Halo {$r['nama']},\n\n".
        "Pengajuan {$r['jenis']} Anda TELAH DISETUJUI.\n".
        "Tanggal: {$r['tanggal_mulai']} s/d {$r['tanggal_selesai']}.\n\n".
        "Terima kasih.\nAdmin PKBM"
    );

    @file_get_contents("https://api.callmebot.com/whatsapp.php?phone=$no_hp&text=$pesan");

/* ===== REJECT ===== */
} elseif ($act == 'reject') {

    mysqli_query($conn,"
        UPDATE izin_cuti
        SET status_approval='rejected',
            approved_at=NOW(),
            approved_by=".$_SESSION['user']['id']."
        WHERE id='$id'
    ");

    $pesan = rawurlencode(
        "Halo {$r['nama']},\n\n".
        "Mohon maaf, pengajuan {$r['jenis']} Anda DITOLAK.\n".
        "Silakan hubungi admin untuk informasi lebih lanjut.\n\n".
        "Admin PKBM"
    );

    @file_get_contents("https://api.callmebot.com/whatsapp.php?phone=$no_hp&text=$pesan");
}

header("Location: izin_cuti.php");
exit;
