<?php
session_start();
require '../config/database.php';

if (!isset($_SESSION['login']) || $_SESSION['user']['role'] != 'admin') {
    header("Location: ../auth/login.php");
    exit;
}

function countData($conn,$table){
    $q = mysqli_query($conn,"SELECT id FROM $table");
    return $q ? mysqli_num_rows($q) : 0;
}
$pkbm = mysqli_fetch_assoc(
    mysqli_query($conn, "SELECT * FROM pkbm WHERE id=1")
);

$jml_siswa  = countData($conn,'siswa');
$jml_tutor  = countData($conn,'tutor');
$jml_mapel  = countData($conn,'mapel');
$jml_materi = countData($conn,'materi');
$jml_kelas  = countData($conn,'kelas');
$q_izin_pending = mysqli_query($conn,"
    SELECT id FROM izin_cuti WHERE status_approval='pending'
");
$jml_izin_pending = mysqli_num_rows($q_izin_pending);

// Statistik
$jml_siswa       = countData($conn,'siswa');
$jml_tutor       = countData($conn,'tutor');
$jml_mapel       = countData($conn,'mapel');
$jml_materi      = countData($conn,'materi');
$jml_kelas       = countData($conn,'kelas');
$jml_ebook       = countData($conn,'ebook'); // <-- tambahan
$q_izin_pending  = mysqli_query($conn,"SELECT id FROM izin_cuti WHERE status_approval='pending'");
$jml_izin_pending = mysqli_num_rows($q_izin_pending);

?>

<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Dashboard Admin PKBM</title>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">

<style>
/* ================= ROOT ================= */
body{
    background:#f4f6f9;
    margin:0;
}

/* ================= SIDEBAR DESKTOP ================= */
.sidebar-desktop{
    position:fixed;
    top:0;
    left:0;
    width:260px;
    height:100vh;
    background:#0b1c2d;
    color:#fff;
    z-index:1030;
}
.sidebar-desktop .logo{
    text-align:center;
    padding:12px 10px;
}
.sidebar-desktop img{
    width:90px;
    margin-bottom:8px;
}
.sidebar-desktop a{
    display:flex;
    align-items:center;
    gap:10px;
    color:#fff;
    text-decoration:none;
    padding:10px 18px;
    margin:2px 10px;
    border-radius:8px;
}
.sidebar-desktop a:hover{
    background:rgba(255,255,255,.15);
}
/* ===== SIDEBAR MOBILE MODERN ===== */
.sidebar-mobile{
    background:#0b1c2d;
    color:#fff;
}

.sidebar-mobile-header{
    background:linear-gradient(135deg,#0d6efd,#0b1c2d);
    color:#fff;
}

.sidebar-logo{
    width:42px;
    height:42px;
    object-fit:contain;
    background:#fff;
    border-radius:10px;
    padding:4px;
}

.sidebar-mobile-body{
    padding:12px;
}

.sidebar-item{
    display:flex;
    align-items:center;
    gap:14px;
    padding:12px 14px;
    border-radius:14px;
    color:#fff;
    text-decoration:none;
    margin-bottom:6px;
    font-size:15px;
    transition:.2s;
}

.sidebar-item i{
    font-size:20px;
    min-width:24px;
    text-align:center;
}

.sidebar-item:hover{
    background:rgba(255,255,255,.15);
}

.sidebar-item.active{
    background:rgba(255,255,255,.25);
    font-weight:600;
}

.sidebar-item.logout{
    background:rgba(255,0,0,.15);
}
.sidebar-item.logout:hover{
    background:rgba(255,0,0,.3);
}

/* ================= TOPBAR ================= */
.topbar{
    position:fixed;
    top:0;
    left:260px;
    right:0;
    height:56px;
    background:#fff;
    border-bottom:1px solid #ddd;
    z-index:1020;
    display:flex;
    align-items:center;
    padding:0 16px;
}

/* ================= MAIN CONTENT ================= */

.main-content{
    margin-left:260px;
    padding-top:70px;
    padding-bottom:60px;

    max-width:1100px;
    margin-right:auto;
    margin-left:260px;
}

/* ================= CARD ================= */
.stat-card{
    border-radius:18px;
    transition:.2s;
}
.stat-card:hover{
    transform:translateY(-4px);
    box-shadow:0 8px 20px rgba(0,0,0,.15);
}

/* ================= FOOTER ================= */
footer{
    position:fixed;
    bottom:0;
    left:260px;
    right:0;
    background:#fff;
    border-top:1px solid #ddd;
    text-align:center;
    font-size:14px;
    padding:8px;
}

/* ================= MOBILE MODE ================= */
@media(max-width:991px){
    .sidebar-desktop{
        display:none;
    }
    .topbar{
        left:0;
    }
    .main-content{
        margin-left:0;
    }
    footer{
        left:0;
    }
}
/* ===== STAT CARD MOBILE ===== */
@media (max-width: 576px) {
  .stat-row {
    margin: 0;
  }

  .stat-card {
    padding: 8px !important;
    border-radius: 10px;
  }

  .stat-card i {
    font-size: 18px !important;
  }

  .stat-card h3 {
    font-size: 16px;
    margin: 2px 0;
  }

  .stat-card small {
    font-size: 11px;
  }
}

/* ================= DESKTOP / LAPTOP IMPROVEMENT ================= */
@media (min-width: 1200px){

    .main-content{
        max-width: calc(100% - 260px);
    }

    .main-content .container-fluid{
        max-width: 1250px;
        margin: auto;
    }

}


    .card{
        border-radius: 20px;
    }

    /* Statistik lebih seimbang */
    .stat-card{
        height: 130px;
        display: flex;
        flex-direction: column;
        justify-content: center;
    }

    /* PROFIL SEKOLAH */
    .profil-sekolah-card{
        padding: 28px 32px;
    }

    .profil-sekolah-card .form-control,
    .profil-sekolah-card textarea{
        font-size: 15px;
        padding: 10px 14px;
    }

    .logo-preview-box{
        height: 100%;
        display: flex;
        flex-direction: column;
        justify-content: center;
        align-items: center;
        border-left: 1px dashed #ddd;
        padding-left: 20px;
    }

    .logo-preview-box img{
        max-height: 200px;
        margin-bottom: 12px;
    }
@media (min-width: 1200px) {
    .container-xxl {
        max-width: 1100px;
    }
}

/* ==============================
   PROFIL SEKOLAH - MOBILE
   ============================== */
@media (max-width: 576px){

  /* card */
  .profil-sekolah-card{
    padding:12px !important;
    border-radius:14px;
  }

  /* header (judul + tombol edit) */
  .profil-sekolah-card > .d-flex{
    flex-direction:column;
    align-items:flex-start !important;
    gap:8px;
  }

  .profil-sekolah-card h5{
    font-size:16px;
  }

  /* isi row */
  .profil-sekolah-card .row{
    gap:12px;
  }

  /* tabel info */
  .profil-sekolah-card table{
    font-size:13px;
  }

  .profil-sekolah-card table th{
    width:120px !important;
    padding:6px 4px;
    white-space:nowrap;
  }

  .profil-sekolah-card table td{
    padding:6px 4px;
  }

  /* logo */
  .profil-sekolah-card img{
    max-height:100px !important;
    margin:0 auto;
    display:block;
  }

  /* kolom jadi full */
  .profil-sekolah-card .col-lg-8,
  .profil-sekolah-card .col-lg-4{
    width:100%;
    text-align:center;
  }

}
.profil-sekolah-card table th{
    width:170px;
    white-space:nowrap;
    vertical-align:top;
}

.profil-sekolah-card table td{
    vertical-align:top;
}

.profil-sekolah-card .titik{
    display:inline-block;
    width:12px;
}
@media (max-width:576px){

  .profil-sekolah-card table th{
      width:120px !important;
      font-size:13px;
  }

  .profil-sekolah-card table td{
      font-size:13px;
  }

  .profil-sekolah-card .titik{
      width:10px;
  }

}


</style>
</head>

<body>

<!-- ================= SIDEBAR DESKTOP ================= -->
<div class="sidebar-desktop d-none d-lg-block">
    <div class="logo">
        <img src="../assets/img/logo.png">
        <h6 class="fw-bold">Sydra Academy</h6>
    </div>

    <a href="dashboard.php"><i class="bi bi-speedometer2"></i> Dashboard</a>
    <a data-bs-toggle="collapse" href="#master">
    <i class="bi bi-database me-2"></i> Master Data
    <i class="bi bi-chevron-down float-end"></i>
  </a>
  <div class="collapse show submenu" id="master">
    <a href="siswa.php"><i class="bi bi-people"></i> Siswa</a>
    <a href="kelas.php"><i class="bi bi-diagram-3"></i> Kelas</a>
    <a href="tutor.php"><i class="bi bi-person-badge"></i> Guru</a>
    <a href="ebook.php"><i class="bi bi-journal-bookmark-fill"></i> E-Book</a>
    <a href="jadwal.php"><i class="bi bi-book"></i> Jadwal Mengajar</a>
    <a href="mapel.php"><i class="bi bi-book"></i> Mapel</a>
    </div>

    <a href="materi.php"><i class="bi bi-journal-text"></i> Materi</a>
    <a href="ebook.php" class="sidebar-item">
    <i class="bi bi-journal-bookmark-fill"></i>
    <span>E-Book</span></a>
    <a href="/pkbm-test/spp/admin/index.php">
    <i class="bi bi-cash-coin"></i> Manajemen SPP
</a>

    <a href="../ujian/ujian.php"><i class="bi bi-pencil-square"></i> CBT</a>
    <a href="izin_cuti.php" class="sidebar-item">
    <i class="bi bi-calendar-check"></i>
    <span>Izin-Cuti</span>
</a>
<a href="presensi_guru.php">
  <i class="bi bi-clipboard-check"></i> Presensi Guru
</a>

    <a href="presensi_admin.php">
  <i class="bi bi-clipboard-check"></i> Presensi Siswa
</a>

    <hr class="text-secondary">
    <a href="../auth/logout.php" class="text-warning">
        <i class="bi bi-box-arrow-right"></i> Logout
    </a>
</div>
<!-- ================= OFFCANVAS SIDEBAR MOBILE MODERN ================= -->
<div class="offcanvas offcanvas-start d-lg-none sidebar-mobile" tabindex="-1" id="sidebarMobile">

    <!-- HEADER -->
    <div class="offcanvas-header sidebar-mobile-header">
        <div class="d-flex align-items-center gap-2">
            <img src="../assets/img/logo.jpg" class="sidebar-logo">
            <div>
                <div class="fw-bold">Sydra Academy</div>
                <small class="text-light opacity-75">Admin Panel</small>
            </div>
        </div>
        <button type="button" class="btn-close btn-close-white"
            data-bs-dismiss="offcanvas"></button>
    </div>

    <!-- BODY -->
    <div class="offcanvas-body sidebar-mobile-body">

        <a href="dashboard.php" class="sidebar-item active">
            <i class="bi bi-speedometer2"></i>
            <span>Dashboard</span>
        </a>

        <a href="siswa.php" class="sidebar-item">
            <i class="bi bi-people"></i>
            <span>Siswa</span>
        </a>

        <a href="kelas.php" class="sidebar-item">
            <i class="bi bi-diagram-3"></i>
            <span>Kelas</span>
        </a>

        <a href="tutor.php" class="sidebar-item">
            <i class="bi bi-person-badge"></i>
            <span>Tutor</span>
        </a>
        <a href="ebook.php" class="sidebar-item">
    <i class="bi bi-journal-bookmark-fill"></i>
    <span>E-Book</span></a>
    <a href="/pkbm-test/spp/admin/index.php" class="sidebar-item">
    <i class="bi bi-cash-coin"></i>
    <span>Manajemen SPP</span>
</a>

        <a href="jadwal.php" class="sidebar-item">
            <i class="bi bi-book"></i>
            <span>Jadwal</span>
        </a>
        <a href="mapel.php" class="sidebar-item">
            <i class="bi bi-book"></i>
            <span>Mapel</span>
        </a>

        <a href="materi.php" class="sidebar-item">
            <i class="bi bi-journal-text"></i>
            <span>Materi</span>
        </a>

        <a href="../ujian/ujian.php" class="sidebar-item">
            <i class="bi bi-pencil-square"></i>
            <span>CBT / Ujian</span>
        </a>
        <a href="izin_cuti.php" class="sidebar-item">
    <i class="bi bi-calendar-check"></i>
    <span>Izin-Cuti</span>
</a>

       <a href="presensi_admin.php" class="sidebar-item">
            <i class="bi bi-calendar-check"></i>
            <span>Presensi Siswa</span>
        </a>
        <a href="presensi_guru.php" class="sidebar-item">
            <i class="bi bi-calendar-check"></i>
            <span>Presensi Guru</span>
        </a>


        <a href="../rapor/rapor.php" class="sidebar-item">
            <i class="bi bi-award"></i>
            <span>Rapor</span>
        </a>

        <hr class="my-3">

        <a href="../auth/logout.php" class="sidebar-item logout">
            <i class="bi bi-box-arrow-right"></i>
            <span>Logout</span>
        </a>

    </div>
</div>

<!-- ================= TOPBAR ================= -->
<div class="topbar">
    <button class="btn btn-outline-primary d-lg-none"
        data-bs-toggle="offcanvas"
        data-bs-target="#sidebarMobile">
        <i class="bi bi-list"></i>
    </button>

    <span class="fw-semibold ms-2">Dashboard Admin</span>

    <span class="ms-auto fw-semibold">
        <?= $_SESSION['user']['nama']; ?>
    </span>
</div>

<!-- ================= MAIN ================= -->
<div class="main-content container-xxl">

    <div class="row g-3 mb-4">
        <!-- Siswa -->
        <div class="col-4 col-md-3">
            <a href="siswa.php" class="text-decoration-none">
                <div class="card stat-card text-white p-3 text-center" style="background: linear-gradient(135deg,#1e3c72,#2a5298); box-shadow:0 6px 15px rgba(0,0,0,0.2);">
                    <i class="bi bi-people fs-3"></i>
                    <h3><?= $jml_siswa ?></h3>
                    <small>Siswa</small>
                </div>
            </a>
        </div>

        <!-- Tutor -->
        <div class="col-4 col-md-3">
            <a href="tutor.php" class="text-decoration-none">
                <div class="card stat-card text-white p-3 text-center" style="background: linear-gradient(135deg,#11998e,#38ef7d); box-shadow:0 6px 15px rgba(0,0,0,0.2);">
                    <i class="bi bi-person-badge fs-3"></i>
                    <h3><?= $jml_tutor ?></h3>
                    <small>Tutor</small>
                </div>
            </a>
        </div>

        <!-- Kelas -->
        <div class="col-4 col-md-3">
            <a href="kelas.php" class="text-decoration-none">
                <div class="card stat-card text-white p-3 text-center" style="background: linear-gradient(135deg,#f7971e,#ffd200); box-shadow:0 6px 15px rgba(0,0,0,0.2);">
                    <i class="bi bi-diagram-3 fs-3"></i>
                    <h3><?= $jml_kelas ?></h3>
                    <small>Kelas</small>
                </div>
            </a>
        </div>

        <!-- Mapel -->
        <div class="col-4 col-md-3">
            <a href="mapel.php" class="text-decoration-none">
                <div class="card stat-card text-white p-3 text-center" style="background: linear-gradient(135deg,#00c6ff,#0072ff); box-shadow:0 6px 15px rgba(0,0,0,0.2);">
                    <i class="bi bi-book fs-3"></i>
                    <h3><?= $jml_mapel ?></h3>
                    <small>Mapel</small>
                </div>
            </a>
        </div>

        <!-- Izin Pending -->
        <div class="col-4 col-md-3">
            <a href="izin_cuti.php" class="text-decoration-none">
                <div class="card stat-card text-white p-3 text-center" style="background: linear-gradient(135deg,#f85032,#e73827); box-shadow:0 6px 15px rgba(0,0,0,0.2);">
                    <i class="bi bi-exclamation-circle fs-3"></i>
                    <h3><?= $jml_izin_pending ?></h3>
                    <small>Izin Pending</small>
                </div>
            </a>
        </div>

        <!-- E-Book -->
        <div class="col-4 col-md-3">
            <a href="ebook.php" class="text-decoration-none">
                <div class="card stat-card text-white p-3 text-center" style="background: linear-gradient(135deg,#7b4397,#dc2430); box-shadow:0 6px 15px rgba(0,0,0,0.2);">
                    <i class="bi bi-journal-bookmark-fill fs-3"></i>
                    <h3><?= $jml_ebook ?></h3>
                    <small>E-Book</small>
                </div>
            </a>
        </div>
    </div>


    <div class="row g-4 mb-4">

    <!-- PROFIL SEKOLAH -->
    <div class="col-lg-7">
        <div class="card profil-sekolah-card h-100">
            <div class="d-flex justify-content-between align-items-center mb-3">
                <h5 class="mb-0">Profil Sekolah</h5>
            </div>

            <div class="row g-4 align-items-center">

                <!-- INFO SEKOLAH -->
                <div class="col-lg-8">
                    <table class="table table-borderless mb-0">
<tr>
    <th style="width:180px;">Nama Sekolah</th>
    <td>: <?= $pkbm['nama_sekolah'] ?? '-' ?></td>
</tr>
<tr>
    <th>NPSN</th>
    <td>: <?= $pkbm['npsn'] ?? '-' ?></td>
</tr>
<tr>
    <th>Alamat</th>
    <td>: <?= $pkbm['alamat'] ?? '-' ?></td>
</tr>
<tr>
    <th>Kepala Sekolah</th>
    <td>: <?= $pkbm['kepala_sekolah'] ?? '-' ?></td>
</tr>
</table>

                </div>

                <!-- LOGO -->
                <div class="col-lg-4 text-center">
                    <img src="../assets/img/<?= $pkbm['logo'] ?? 'logo.png' ?>"
                         class="img-thumbnail"
                         style="max-height:180px">
                </div>
                    <button class="btn btn-outline-primary btn-sm"
                    data-bs-toggle="modal"
                    data-bs-target="#modalProfilSekolah">
                    <i class="bi bi-pencil"></i> Edit
                </button>
            </div>
        </div>
    </div>

    <!-- INFORMASI SISTEM -->
    <div class="col-lg-5">
        <div class="card h-100 p-4">
            <h5 class="mb-3">Informasi Sistem</h5>

            <ul class="list-group list-group-flush small">
                <li class="list-group-item d-flex justify-content-between">
                    <span>Status</span>
                    <span class="badge bg-success">Aktif</span>
                </li>
                <li class="list-group-item d-flex justify-content-between">
                    <span>Mode</span>
                    <span>Education Daring</span>
                </li>
                <li class="list-group-item d-flex justify-content-between">
                    <span>Versi</span>
                    <span>1.0</span>
                </li>
                <li class="list-group-item d-flex justify-content-between">
                    <span>Database</span>
                    <span><?= htmlspecialchars(mysqli_get_server_info($conn)) ?></span>
                </li>
                <li class="list-group-item d-flex justify-content-between">
                    <span>Server Time</span>
                    <span><?= date('d-m-Y H:i') ?></span>
                </li>
                <li class="list-group-item d-flex justify-content-between">
                    <span>Developer</span>
                    <span>TEAM PKBM Taruna Qurani</span>
                </li>
            </ul>
        </div>
    </div>

</div>

</div>
<div class="modal fade" id="modalProfilSekolah" tabindex="-1">
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content">

            <form action="pkbm_update.php" method="post" enctype="multipart/form-data">
                <input type="hidden" name="id" value="1">

                <div class="modal-header">
                    <h5 class="modal-title">Edit Profil Sekolah</h5>
                    <button type="button" class="btn-close"
                        data-bs-dismiss="modal"></button>
                </div>

                <div class="modal-body">
                    <div class="row g-3">

                        <!-- FORM -->
                        <div class="col-md-8">
                            <div class="mb-2">
                                <label class="form-label">Nama Sekolah</label>
                                <input type="text" name="nama_sekolah"
                                    class="form-control"
                                    value="<?= $pkbm['nama_sekolah'] ?? '' ?>"
                                    required>
                            </div>

                            <div class="mb-2">
                                <label class="form-label">NPSN</label>
                                <input type="text" name="npsn"
                                    class="form-control"
                                    value="<?= $pkbm['npsn'] ?? '' ?>">
                            </div>

                            <div class="mb-2">
                                <label class="form-label">Alamat</label>
                                <textarea name="alamat" class="form-control" rows="3"><?= $pkbm['alamat'] ?? '' ?></textarea>
                            </div>

                            <div class="mb-2">
                                <label class="form-label">Kepala Sekolah</label>
                                <input type="text" name="kepala_sekolah"
                                    class="form-control"
                                    value="<?= $pkbm['kepala_sekolah'] ?? '' ?>">
                            </div>
                        </div>

                        <!-- LOGO -->
                        <div class="col-md-4 text-center">
                            <label class="form-label">Logo Sekolah</label>

                            <img id="previewLogo"
                                src="../assets/img/<?= $pkbm['logo'] ?? 'logo.png' ?>"
                                class="img-thumbnail mb-2"
                                style="max-height:160px">

                            <input type="file"
                                name="logo"
                                class="form-control"
                                accept="image/*"
                                onchange="previewLogoImage(this)">
                        </div>

                    </div>
                </div>

                <div class="modal-footer">
                    <button type="button"
                        class="btn btn-secondary"
                        data-bs-dismiss="modal">
                        Batal
                    </button>

                    <button class="btn btn-primary">
                        <i class="bi bi-save"></i> Simpan
                    </button>
                </div>

            </form>

        </div>
    </div>
</div>


<script>
function previewLogoImage(input){
    const img = document.getElementById('previewLogo');
    const file = input.files[0];

    if(file){
        const reader = new FileReader();
        reader.onload = function(e){
            img.src = e.target.result;
        };
        reader.readAsDataURL(file);
    }
}
</script>


<!-- ================= FOOTER ================= -->
<footer>
    © <?= date('Y'); ?> Sydra Academy — Developed by <b>TEAM PKBM TARUNA QURANI</b>
</footer>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
